/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskTypeValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartReplicationTaskRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, StartReplicationTaskRequest> {
    private static final SdkField<String> REPLICATION_TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationTaskArn").getter(StartReplicationTaskRequest.getter(StartReplicationTaskRequest::replicationTaskArn)).setter(StartReplicationTaskRequest.setter(Builder::replicationTaskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskArn").build()}).build();
    private static final SdkField<String> START_REPLICATION_TASK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartReplicationTaskType").getter(StartReplicationTaskRequest.getter(StartReplicationTaskRequest::startReplicationTaskTypeAsString)).setter(StartReplicationTaskRequest.setter(Builder::startReplicationTaskType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartReplicationTaskType").build()}).build();
    private static final SdkField<Instant> CDC_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CdcStartTime").getter(StartReplicationTaskRequest.getter(StartReplicationTaskRequest::cdcStartTime)).setter(StartReplicationTaskRequest.setter(Builder::cdcStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartTime").build()}).build();
    private static final SdkField<String> CDC_START_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CdcStartPosition").getter(StartReplicationTaskRequest.getter(StartReplicationTaskRequest::cdcStartPosition)).setter(StartReplicationTaskRequest.setter(Builder::cdcStartPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartPosition").build()}).build();
    private static final SdkField<String> CDC_STOP_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CdcStopPosition").getter(StartReplicationTaskRequest.getter(StartReplicationTaskRequest::cdcStopPosition)).setter(StartReplicationTaskRequest.setter(Builder::cdcStopPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStopPosition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_TASK_ARN_FIELD, START_REPLICATION_TASK_TYPE_FIELD, CDC_START_TIME_FIELD, CDC_START_POSITION_FIELD, CDC_STOP_POSITION_FIELD));
    private final String replicationTaskArn;
    private final String startReplicationTaskType;
    private final Instant cdcStartTime;
    private final String cdcStartPosition;
    private final String cdcStopPosition;

    private StartReplicationTaskRequest(BuilderImpl builder) {
        super(builder);
        this.replicationTaskArn = builder.replicationTaskArn;
        this.startReplicationTaskType = builder.startReplicationTaskType;
        this.cdcStartTime = builder.cdcStartTime;
        this.cdcStartPosition = builder.cdcStartPosition;
        this.cdcStopPosition = builder.cdcStopPosition;
    }

    public final String replicationTaskArn() {
        return this.replicationTaskArn;
    }

    public final StartReplicationTaskTypeValue startReplicationTaskType() {
        return StartReplicationTaskTypeValue.fromValue(this.startReplicationTaskType);
    }

    public final String startReplicationTaskTypeAsString() {
        return this.startReplicationTaskType;
    }

    public final Instant cdcStartTime() {
        return this.cdcStartTime;
    }

    public final String cdcStartPosition() {
        return this.cdcStartPosition;
    }

    public final String cdcStopPosition() {
        return this.cdcStopPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startReplicationTaskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStartPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStopPosition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartReplicationTaskRequest)) {
            return false;
        }
        StartReplicationTaskRequest other = (StartReplicationTaskRequest)((Object)obj);
        return Objects.equals(this.replicationTaskArn(), other.replicationTaskArn()) && Objects.equals(this.startReplicationTaskTypeAsString(), other.startReplicationTaskTypeAsString()) && Objects.equals(this.cdcStartTime(), other.cdcStartTime()) && Objects.equals(this.cdcStartPosition(), other.cdcStartPosition()) && Objects.equals(this.cdcStopPosition(), other.cdcStopPosition());
    }

    public final String toString() {
        return ToString.builder((String)"StartReplicationTaskRequest").add("ReplicationTaskArn", (Object)this.replicationTaskArn()).add("StartReplicationTaskType", (Object)this.startReplicationTaskTypeAsString()).add("CdcStartTime", (Object)this.cdcStartTime()).add("CdcStartPosition", (Object)this.cdcStartPosition()).add("CdcStopPosition", (Object)this.cdcStopPosition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationTaskArn": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskArn()));
            }
            case "StartReplicationTaskType": {
                return Optional.ofNullable(clazz.cast(this.startReplicationTaskTypeAsString()));
            }
            case "CdcStartTime": {
                return Optional.ofNullable(clazz.cast(this.cdcStartTime()));
            }
            case "CdcStartPosition": {
                return Optional.ofNullable(clazz.cast(this.cdcStartPosition()));
            }
            case "CdcStopPosition": {
                return Optional.ofNullable(clazz.cast(this.cdcStopPosition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartReplicationTaskRequest, T> g) {
        return obj -> g.apply((StartReplicationTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String replicationTaskArn;
        private String startReplicationTaskType;
        private Instant cdcStartTime;
        private String cdcStartPosition;
        private String cdcStopPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(StartReplicationTaskRequest model) {
            super(model);
            this.replicationTaskArn(model.replicationTaskArn);
            this.startReplicationTaskType(model.startReplicationTaskType);
            this.cdcStartTime(model.cdcStartTime);
            this.cdcStartPosition(model.cdcStartPosition);
            this.cdcStopPosition(model.cdcStopPosition);
        }

        public final String getReplicationTaskArn() {
            return this.replicationTaskArn;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        @Override
        @Transient
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final String getStartReplicationTaskType() {
            return this.startReplicationTaskType;
        }

        public final void setStartReplicationTaskType(String startReplicationTaskType) {
            this.startReplicationTaskType = startReplicationTaskType;
        }

        @Override
        @Transient
        public final Builder startReplicationTaskType(String startReplicationTaskType) {
            this.startReplicationTaskType = startReplicationTaskType;
            return this;
        }

        @Override
        @Transient
        public final Builder startReplicationTaskType(StartReplicationTaskTypeValue startReplicationTaskType) {
            this.startReplicationTaskType(startReplicationTaskType == null ? null : startReplicationTaskType.toString());
            return this;
        }

        public final Instant getCdcStartTime() {
            return this.cdcStartTime;
        }

        public final void setCdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
        }

        @Override
        @Transient
        public final Builder cdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
            return this;
        }

        public final String getCdcStartPosition() {
            return this.cdcStartPosition;
        }

        public final void setCdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
        }

        @Override
        @Transient
        public final Builder cdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
            return this;
        }

        public final String getCdcStopPosition() {
            return this.cdcStopPosition;
        }

        public final void setCdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
        }

        @Override
        @Transient
        public final Builder cdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartReplicationTaskRequest build() {
            return new StartReplicationTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartReplicationTaskRequest> {
        public Builder replicationTaskArn(String var1);

        public Builder startReplicationTaskType(String var1);

        public Builder startReplicationTaskType(StartReplicationTaskTypeValue var1);

        public Builder cdcStartTime(Instant var1);

        public Builder cdcStartPosition(String var1);

        public Builder cdcStopPosition(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

