/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse;

public class DescribeReplicationTasksIterable
implements SdkIterable<DescribeReplicationTasksResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeReplicationTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReplicationTasksIterable(DatabaseMigrationClient client, DescribeReplicationTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReplicationTasksResponseFetcher();
    }

    public Iterator<DescribeReplicationTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeReplicationTasksResponseFetcher
    implements SyncPageFetcher<DescribeReplicationTasksResponse> {
        private DescribeReplicationTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeReplicationTasksResponse nextPage(DescribeReplicationTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationTasksIterable.this.client.describeReplicationTasks(DescribeReplicationTasksIterable.this.firstRequest);
            }
            return DescribeReplicationTasksIterable.this.client.describeReplicationTasks((DescribeReplicationTasksRequest)((Object)DescribeReplicationTasksIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

