/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DatePartitionDelimiterValue {
    SLASH("SLASH"),
    UNDERSCORE("UNDERSCORE"),
    DASH("DASH"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DatePartitionDelimiterValue> VALUE_MAP;
    private final String value;

    private DatePartitionDelimiterValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DatePartitionDelimiterValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DatePartitionDelimiterValue> knownValues() {
        EnumSet<DatePartitionDelimiterValue> knownValues = EnumSet.allOf(DatePartitionDelimiterValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DatePartitionDelimiterValue.class, DatePartitionDelimiterValue::toString);
    }
}

