/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AuthMechanismValue {
    DEFAULT("default"),
    MONGODB_CR("mongodb_cr"),
    SCRAM_SHA_1("scram_sha_1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AuthMechanismValue> VALUE_MAP;
    private final String value;

    private AuthMechanismValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthMechanismValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthMechanismValue> knownValues() {
        EnumSet<AuthMechanismValue> knownValues = EnumSet.allOf(AuthMechanismValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AuthMechanismValue.class, AuthMechanismValue::toString);
    }
}

