/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.EncryptionModeValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftSettings> {
    private static final SdkField<Boolean> ACCEPT_ANY_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AcceptAnyDate").getter(RedshiftSettings.getter(RedshiftSettings::acceptAnyDate)).setter(RedshiftSettings.setter(Builder::acceptAnyDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptAnyDate").build()}).build();
    private static final SdkField<String> AFTER_CONNECT_SCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AfterConnectScript").getter(RedshiftSettings.getter(RedshiftSettings::afterConnectScript)).setter(RedshiftSettings.setter(Builder::afterConnectScript)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AfterConnectScript").build()}).build();
    private static final SdkField<String> BUCKET_FOLDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketFolder").getter(RedshiftSettings.getter(RedshiftSettings::bucketFolder)).setter(RedshiftSettings.setter(Builder::bucketFolder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketFolder").build()}).build();
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketName").getter(RedshiftSettings.getter(RedshiftSettings::bucketName)).setter(RedshiftSettings.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()}).build();
    private static final SdkField<Boolean> CASE_SENSITIVE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CaseSensitiveNames").getter(RedshiftSettings.getter(RedshiftSettings::caseSensitiveNames)).setter(RedshiftSettings.setter(Builder::caseSensitiveNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaseSensitiveNames").build()}).build();
    private static final SdkField<Boolean> COMP_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CompUpdate").getter(RedshiftSettings.getter(RedshiftSettings::compUpdate)).setter(RedshiftSettings.setter(Builder::compUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompUpdate").build()}).build();
    private static final SdkField<Integer> CONNECTION_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConnectionTimeout").getter(RedshiftSettings.getter(RedshiftSettings::connectionTimeout)).setter(RedshiftSettings.setter(Builder::connectionTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTimeout").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(RedshiftSettings.getter(RedshiftSettings::databaseName)).setter(RedshiftSettings.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> DATE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DateFormat").getter(RedshiftSettings.getter(RedshiftSettings::dateFormat)).setter(RedshiftSettings.setter(Builder::dateFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateFormat").build()}).build();
    private static final SdkField<Boolean> EMPTY_AS_NULL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EmptyAsNull").getter(RedshiftSettings.getter(RedshiftSettings::emptyAsNull)).setter(RedshiftSettings.setter(Builder::emptyAsNull)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmptyAsNull").build()}).build();
    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionMode").getter(RedshiftSettings.getter(RedshiftSettings::encryptionModeAsString)).setter(RedshiftSettings.setter(Builder::encryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionMode").build()}).build();
    private static final SdkField<Boolean> EXPLICIT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExplicitIds").getter(RedshiftSettings.getter(RedshiftSettings::explicitIds)).setter(RedshiftSettings.setter(Builder::explicitIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplicitIds").build()}).build();
    private static final SdkField<Integer> FILE_TRANSFER_UPLOAD_STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FileTransferUploadStreams").getter(RedshiftSettings.getter(RedshiftSettings::fileTransferUploadStreams)).setter(RedshiftSettings.setter(Builder::fileTransferUploadStreams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileTransferUploadStreams").build()}).build();
    private static final SdkField<Integer> LOAD_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LoadTimeout").getter(RedshiftSettings.getter(RedshiftSettings::loadTimeout)).setter(RedshiftSettings.setter(Builder::loadTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadTimeout").build()}).build();
    private static final SdkField<Integer> MAX_FILE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxFileSize").getter(RedshiftSettings.getter(RedshiftSettings::maxFileSize)).setter(RedshiftSettings.setter(Builder::maxFileSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFileSize").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(RedshiftSettings.getter(RedshiftSettings::password)).setter(RedshiftSettings.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(RedshiftSettings.getter(RedshiftSettings::port)).setter(RedshiftSettings.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<Boolean> REMOVE_QUOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RemoveQuotes").getter(RedshiftSettings.getter(RedshiftSettings::removeQuotes)).setter(RedshiftSettings.setter(Builder::removeQuotes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveQuotes").build()}).build();
    private static final SdkField<String> REPLACE_INVALID_CHARS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplaceInvalidChars").getter(RedshiftSettings.getter(RedshiftSettings::replaceInvalidChars)).setter(RedshiftSettings.setter(Builder::replaceInvalidChars)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceInvalidChars").build()}).build();
    private static final SdkField<String> REPLACE_CHARS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplaceChars").getter(RedshiftSettings.getter(RedshiftSettings::replaceChars)).setter(RedshiftSettings.setter(Builder::replaceChars)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceChars").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(RedshiftSettings.getter(RedshiftSettings::serverName)).setter(RedshiftSettings.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceAccessRoleArn").getter(RedshiftSettings.getter(RedshiftSettings::serviceAccessRoleArn)).setter(RedshiftSettings.setter(Builder::serviceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build()}).build();
    private static final SdkField<String> SERVER_SIDE_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerSideEncryptionKmsKeyId").getter(RedshiftSettings.getter(RedshiftSettings::serverSideEncryptionKmsKeyId)).setter(RedshiftSettings.setter(Builder::serverSideEncryptionKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideEncryptionKmsKeyId").build()}).build();
    private static final SdkField<String> TIME_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeFormat").getter(RedshiftSettings.getter(RedshiftSettings::timeFormat)).setter(RedshiftSettings.setter(Builder::timeFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeFormat").build()}).build();
    private static final SdkField<Boolean> TRIM_BLANKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TrimBlanks").getter(RedshiftSettings.getter(RedshiftSettings::trimBlanks)).setter(RedshiftSettings.setter(Builder::trimBlanks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrimBlanks").build()}).build();
    private static final SdkField<Boolean> TRUNCATE_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TruncateColumns").getter(RedshiftSettings.getter(RedshiftSettings::truncateColumns)).setter(RedshiftSettings.setter(Builder::truncateColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruncateColumns").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(RedshiftSettings.getter(RedshiftSettings::username)).setter(RedshiftSettings.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<Integer> WRITE_BUFFER_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WriteBufferSize").getter(RedshiftSettings.getter(RedshiftSettings::writeBufferSize)).setter(RedshiftSettings.setter(Builder::writeBufferSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteBufferSize").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerAccessRoleArn").getter(RedshiftSettings.getter(RedshiftSettings::secretsManagerAccessRoleArn)).setter(RedshiftSettings.setter(Builder::secretsManagerAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerAccessRoleArn").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_SECRET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerSecretId").getter(RedshiftSettings.getter(RedshiftSettings::secretsManagerSecretId)).setter(RedshiftSettings.setter(Builder::secretsManagerSecretId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerSecretId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_ANY_DATE_FIELD, AFTER_CONNECT_SCRIPT_FIELD, BUCKET_FOLDER_FIELD, BUCKET_NAME_FIELD, CASE_SENSITIVE_NAMES_FIELD, COMP_UPDATE_FIELD, CONNECTION_TIMEOUT_FIELD, DATABASE_NAME_FIELD, DATE_FORMAT_FIELD, EMPTY_AS_NULL_FIELD, ENCRYPTION_MODE_FIELD, EXPLICIT_IDS_FIELD, FILE_TRANSFER_UPLOAD_STREAMS_FIELD, LOAD_TIMEOUT_FIELD, MAX_FILE_SIZE_FIELD, PASSWORD_FIELD, PORT_FIELD, REMOVE_QUOTES_FIELD, REPLACE_INVALID_CHARS_FIELD, REPLACE_CHARS_FIELD, SERVER_NAME_FIELD, SERVICE_ACCESS_ROLE_ARN_FIELD, SERVER_SIDE_ENCRYPTION_KMS_KEY_ID_FIELD, TIME_FORMAT_FIELD, TRIM_BLANKS_FIELD, TRUNCATE_COLUMNS_FIELD, USERNAME_FIELD, WRITE_BUFFER_SIZE_FIELD, SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD, SECRETS_MANAGER_SECRET_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean acceptAnyDate;
    private final String afterConnectScript;
    private final String bucketFolder;
    private final String bucketName;
    private final Boolean caseSensitiveNames;
    private final Boolean compUpdate;
    private final Integer connectionTimeout;
    private final String databaseName;
    private final String dateFormat;
    private final Boolean emptyAsNull;
    private final String encryptionMode;
    private final Boolean explicitIds;
    private final Integer fileTransferUploadStreams;
    private final Integer loadTimeout;
    private final Integer maxFileSize;
    private final String password;
    private final Integer port;
    private final Boolean removeQuotes;
    private final String replaceInvalidChars;
    private final String replaceChars;
    private final String serverName;
    private final String serviceAccessRoleArn;
    private final String serverSideEncryptionKmsKeyId;
    private final String timeFormat;
    private final Boolean trimBlanks;
    private final Boolean truncateColumns;
    private final String username;
    private final Integer writeBufferSize;
    private final String secretsManagerAccessRoleArn;
    private final String secretsManagerSecretId;

    private RedshiftSettings(BuilderImpl builder) {
        this.acceptAnyDate = builder.acceptAnyDate;
        this.afterConnectScript = builder.afterConnectScript;
        this.bucketFolder = builder.bucketFolder;
        this.bucketName = builder.bucketName;
        this.caseSensitiveNames = builder.caseSensitiveNames;
        this.compUpdate = builder.compUpdate;
        this.connectionTimeout = builder.connectionTimeout;
        this.databaseName = builder.databaseName;
        this.dateFormat = builder.dateFormat;
        this.emptyAsNull = builder.emptyAsNull;
        this.encryptionMode = builder.encryptionMode;
        this.explicitIds = builder.explicitIds;
        this.fileTransferUploadStreams = builder.fileTransferUploadStreams;
        this.loadTimeout = builder.loadTimeout;
        this.maxFileSize = builder.maxFileSize;
        this.password = builder.password;
        this.port = builder.port;
        this.removeQuotes = builder.removeQuotes;
        this.replaceInvalidChars = builder.replaceInvalidChars;
        this.replaceChars = builder.replaceChars;
        this.serverName = builder.serverName;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.serverSideEncryptionKmsKeyId = builder.serverSideEncryptionKmsKeyId;
        this.timeFormat = builder.timeFormat;
        this.trimBlanks = builder.trimBlanks;
        this.truncateColumns = builder.truncateColumns;
        this.username = builder.username;
        this.writeBufferSize = builder.writeBufferSize;
        this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
        this.secretsManagerSecretId = builder.secretsManagerSecretId;
    }

    public final Boolean acceptAnyDate() {
        return this.acceptAnyDate;
    }

    public final String afterConnectScript() {
        return this.afterConnectScript;
    }

    public final String bucketFolder() {
        return this.bucketFolder;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final Boolean caseSensitiveNames() {
        return this.caseSensitiveNames;
    }

    public final Boolean compUpdate() {
        return this.compUpdate;
    }

    public final Integer connectionTimeout() {
        return this.connectionTimeout;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String dateFormat() {
        return this.dateFormat;
    }

    public final Boolean emptyAsNull() {
        return this.emptyAsNull;
    }

    public final EncryptionModeValue encryptionMode() {
        return EncryptionModeValue.fromValue(this.encryptionMode);
    }

    public final String encryptionModeAsString() {
        return this.encryptionMode;
    }

    public final Boolean explicitIds() {
        return this.explicitIds;
    }

    public final Integer fileTransferUploadStreams() {
        return this.fileTransferUploadStreams;
    }

    public final Integer loadTimeout() {
        return this.loadTimeout;
    }

    public final Integer maxFileSize() {
        return this.maxFileSize;
    }

    public final String password() {
        return this.password;
    }

    public final Integer port() {
        return this.port;
    }

    public final Boolean removeQuotes() {
        return this.removeQuotes;
    }

    public final String replaceInvalidChars() {
        return this.replaceInvalidChars;
    }

    public final String replaceChars() {
        return this.replaceChars;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public final String serverSideEncryptionKmsKeyId() {
        return this.serverSideEncryptionKmsKeyId;
    }

    public final String timeFormat() {
        return this.timeFormat;
    }

    public final Boolean trimBlanks() {
        return this.trimBlanks;
    }

    public final Boolean truncateColumns() {
        return this.truncateColumns;
    }

    public final String username() {
        return this.username;
    }

    public final Integer writeBufferSize() {
        return this.writeBufferSize;
    }

    public final String secretsManagerAccessRoleArn() {
        return this.secretsManagerAccessRoleArn;
    }

    public final String secretsManagerSecretId() {
        return this.secretsManagerSecretId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptAnyDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterConnectScript());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketFolder());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.caseSensitiveNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.compUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.emptyAsNull());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.explicitIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileTransferUploadStreams());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFileSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeQuotes());
        hashCode = 31 * hashCode + Objects.hashCode(this.replaceInvalidChars());
        hashCode = 31 * hashCode + Objects.hashCode(this.replaceChars());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideEncryptionKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.trimBlanks());
        hashCode = 31 * hashCode + Objects.hashCode(this.truncateColumns());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeBufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerSecretId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftSettings)) {
            return false;
        }
        RedshiftSettings other = (RedshiftSettings)obj;
        return Objects.equals(this.acceptAnyDate(), other.acceptAnyDate()) && Objects.equals(this.afterConnectScript(), other.afterConnectScript()) && Objects.equals(this.bucketFolder(), other.bucketFolder()) && Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.caseSensitiveNames(), other.caseSensitiveNames()) && Objects.equals(this.compUpdate(), other.compUpdate()) && Objects.equals(this.connectionTimeout(), other.connectionTimeout()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.dateFormat(), other.dateFormat()) && Objects.equals(this.emptyAsNull(), other.emptyAsNull()) && Objects.equals(this.encryptionModeAsString(), other.encryptionModeAsString()) && Objects.equals(this.explicitIds(), other.explicitIds()) && Objects.equals(this.fileTransferUploadStreams(), other.fileTransferUploadStreams()) && Objects.equals(this.loadTimeout(), other.loadTimeout()) && Objects.equals(this.maxFileSize(), other.maxFileSize()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.removeQuotes(), other.removeQuotes()) && Objects.equals(this.replaceInvalidChars(), other.replaceInvalidChars()) && Objects.equals(this.replaceChars(), other.replaceChars()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.serviceAccessRoleArn(), other.serviceAccessRoleArn()) && Objects.equals(this.serverSideEncryptionKmsKeyId(), other.serverSideEncryptionKmsKeyId()) && Objects.equals(this.timeFormat(), other.timeFormat()) && Objects.equals(this.trimBlanks(), other.trimBlanks()) && Objects.equals(this.truncateColumns(), other.truncateColumns()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.writeBufferSize(), other.writeBufferSize()) && Objects.equals(this.secretsManagerAccessRoleArn(), other.secretsManagerAccessRoleArn()) && Objects.equals(this.secretsManagerSecretId(), other.secretsManagerSecretId());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftSettings").add("AcceptAnyDate", (Object)this.acceptAnyDate()).add("AfterConnectScript", (Object)this.afterConnectScript()).add("BucketFolder", (Object)this.bucketFolder()).add("BucketName", (Object)this.bucketName()).add("CaseSensitiveNames", (Object)this.caseSensitiveNames()).add("CompUpdate", (Object)this.compUpdate()).add("ConnectionTimeout", (Object)this.connectionTimeout()).add("DatabaseName", (Object)this.databaseName()).add("DateFormat", (Object)this.dateFormat()).add("EmptyAsNull", (Object)this.emptyAsNull()).add("EncryptionMode", (Object)this.encryptionModeAsString()).add("ExplicitIds", (Object)this.explicitIds()).add("FileTransferUploadStreams", (Object)this.fileTransferUploadStreams()).add("LoadTimeout", (Object)this.loadTimeout()).add("MaxFileSize", (Object)this.maxFileSize()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("Port", (Object)this.port()).add("RemoveQuotes", (Object)this.removeQuotes()).add("ReplaceInvalidChars", (Object)this.replaceInvalidChars()).add("ReplaceChars", (Object)this.replaceChars()).add("ServerName", (Object)this.serverName()).add("ServiceAccessRoleArn", (Object)this.serviceAccessRoleArn()).add("ServerSideEncryptionKmsKeyId", (Object)this.serverSideEncryptionKmsKeyId()).add("TimeFormat", (Object)this.timeFormat()).add("TrimBlanks", (Object)this.trimBlanks()).add("TruncateColumns", (Object)this.truncateColumns()).add("Username", (Object)this.username()).add("WriteBufferSize", (Object)this.writeBufferSize()).add("SecretsManagerAccessRoleArn", (Object)this.secretsManagerAccessRoleArn()).add("SecretsManagerSecretId", (Object)this.secretsManagerSecretId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptAnyDate": {
                return Optional.ofNullable(clazz.cast(this.acceptAnyDate()));
            }
            case "AfterConnectScript": {
                return Optional.ofNullable(clazz.cast(this.afterConnectScript()));
            }
            case "BucketFolder": {
                return Optional.ofNullable(clazz.cast(this.bucketFolder()));
            }
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "CaseSensitiveNames": {
                return Optional.ofNullable(clazz.cast(this.caseSensitiveNames()));
            }
            case "CompUpdate": {
                return Optional.ofNullable(clazz.cast(this.compUpdate()));
            }
            case "ConnectionTimeout": {
                return Optional.ofNullable(clazz.cast(this.connectionTimeout()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "DateFormat": {
                return Optional.ofNullable(clazz.cast(this.dateFormat()));
            }
            case "EmptyAsNull": {
                return Optional.ofNullable(clazz.cast(this.emptyAsNull()));
            }
            case "EncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.encryptionModeAsString()));
            }
            case "ExplicitIds": {
                return Optional.ofNullable(clazz.cast(this.explicitIds()));
            }
            case "FileTransferUploadStreams": {
                return Optional.ofNullable(clazz.cast(this.fileTransferUploadStreams()));
            }
            case "LoadTimeout": {
                return Optional.ofNullable(clazz.cast(this.loadTimeout()));
            }
            case "MaxFileSize": {
                return Optional.ofNullable(clazz.cast(this.maxFileSize()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "RemoveQuotes": {
                return Optional.ofNullable(clazz.cast(this.removeQuotes()));
            }
            case "ReplaceInvalidChars": {
                return Optional.ofNullable(clazz.cast(this.replaceInvalidChars()));
            }
            case "ReplaceChars": {
                return Optional.ofNullable(clazz.cast(this.replaceChars()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "ServiceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessRoleArn()));
            }
            case "ServerSideEncryptionKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.serverSideEncryptionKmsKeyId()));
            }
            case "TimeFormat": {
                return Optional.ofNullable(clazz.cast(this.timeFormat()));
            }
            case "TrimBlanks": {
                return Optional.ofNullable(clazz.cast(this.trimBlanks()));
            }
            case "TruncateColumns": {
                return Optional.ofNullable(clazz.cast(this.truncateColumns()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "WriteBufferSize": {
                return Optional.ofNullable(clazz.cast(this.writeBufferSize()));
            }
            case "SecretsManagerAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerAccessRoleArn()));
            }
            case "SecretsManagerSecretId": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerSecretId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftSettings, T> g) {
        return obj -> g.apply((RedshiftSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean acceptAnyDate;
        private String afterConnectScript;
        private String bucketFolder;
        private String bucketName;
        private Boolean caseSensitiveNames;
        private Boolean compUpdate;
        private Integer connectionTimeout;
        private String databaseName;
        private String dateFormat;
        private Boolean emptyAsNull;
        private String encryptionMode;
        private Boolean explicitIds;
        private Integer fileTransferUploadStreams;
        private Integer loadTimeout;
        private Integer maxFileSize;
        private String password;
        private Integer port;
        private Boolean removeQuotes;
        private String replaceInvalidChars;
        private String replaceChars;
        private String serverName;
        private String serviceAccessRoleArn;
        private String serverSideEncryptionKmsKeyId;
        private String timeFormat;
        private Boolean trimBlanks;
        private Boolean truncateColumns;
        private String username;
        private Integer writeBufferSize;
        private String secretsManagerAccessRoleArn;
        private String secretsManagerSecretId;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftSettings model) {
            this.acceptAnyDate(model.acceptAnyDate);
            this.afterConnectScript(model.afterConnectScript);
            this.bucketFolder(model.bucketFolder);
            this.bucketName(model.bucketName);
            this.caseSensitiveNames(model.caseSensitiveNames);
            this.compUpdate(model.compUpdate);
            this.connectionTimeout(model.connectionTimeout);
            this.databaseName(model.databaseName);
            this.dateFormat(model.dateFormat);
            this.emptyAsNull(model.emptyAsNull);
            this.encryptionMode(model.encryptionMode);
            this.explicitIds(model.explicitIds);
            this.fileTransferUploadStreams(model.fileTransferUploadStreams);
            this.loadTimeout(model.loadTimeout);
            this.maxFileSize(model.maxFileSize);
            this.password(model.password);
            this.port(model.port);
            this.removeQuotes(model.removeQuotes);
            this.replaceInvalidChars(model.replaceInvalidChars);
            this.replaceChars(model.replaceChars);
            this.serverName(model.serverName);
            this.serviceAccessRoleArn(model.serviceAccessRoleArn);
            this.serverSideEncryptionKmsKeyId(model.serverSideEncryptionKmsKeyId);
            this.timeFormat(model.timeFormat);
            this.trimBlanks(model.trimBlanks);
            this.truncateColumns(model.truncateColumns);
            this.username(model.username);
            this.writeBufferSize(model.writeBufferSize);
            this.secretsManagerAccessRoleArn(model.secretsManagerAccessRoleArn);
            this.secretsManagerSecretId(model.secretsManagerSecretId);
        }

        public final Boolean getAcceptAnyDate() {
            return this.acceptAnyDate;
        }

        public final void setAcceptAnyDate(Boolean acceptAnyDate) {
            this.acceptAnyDate = acceptAnyDate;
        }

        @Override
        public final Builder acceptAnyDate(Boolean acceptAnyDate) {
            this.acceptAnyDate = acceptAnyDate;
            return this;
        }

        public final String getAfterConnectScript() {
            return this.afterConnectScript;
        }

        public final void setAfterConnectScript(String afterConnectScript) {
            this.afterConnectScript = afterConnectScript;
        }

        @Override
        public final Builder afterConnectScript(String afterConnectScript) {
            this.afterConnectScript = afterConnectScript;
            return this;
        }

        public final String getBucketFolder() {
            return this.bucketFolder;
        }

        public final void setBucketFolder(String bucketFolder) {
            this.bucketFolder = bucketFolder;
        }

        @Override
        public final Builder bucketFolder(String bucketFolder) {
            this.bucketFolder = bucketFolder;
            return this;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final Boolean getCaseSensitiveNames() {
            return this.caseSensitiveNames;
        }

        public final void setCaseSensitiveNames(Boolean caseSensitiveNames) {
            this.caseSensitiveNames = caseSensitiveNames;
        }

        @Override
        public final Builder caseSensitiveNames(Boolean caseSensitiveNames) {
            this.caseSensitiveNames = caseSensitiveNames;
            return this;
        }

        public final Boolean getCompUpdate() {
            return this.compUpdate;
        }

        public final void setCompUpdate(Boolean compUpdate) {
            this.compUpdate = compUpdate;
        }

        @Override
        public final Builder compUpdate(Boolean compUpdate) {
            this.compUpdate = compUpdate;
            return this;
        }

        public final Integer getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public final void setConnectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        @Override
        public final Builder connectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDateFormat() {
            return this.dateFormat;
        }

        public final void setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public final Builder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public final Boolean getEmptyAsNull() {
            return this.emptyAsNull;
        }

        public final void setEmptyAsNull(Boolean emptyAsNull) {
            this.emptyAsNull = emptyAsNull;
        }

        @Override
        public final Builder emptyAsNull(Boolean emptyAsNull) {
            this.emptyAsNull = emptyAsNull;
            return this;
        }

        public final String getEncryptionMode() {
            return this.encryptionMode;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        @Override
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        @Override
        public final Builder encryptionMode(EncryptionModeValue encryptionMode) {
            this.encryptionMode(encryptionMode == null ? null : encryptionMode.toString());
            return this;
        }

        public final Boolean getExplicitIds() {
            return this.explicitIds;
        }

        public final void setExplicitIds(Boolean explicitIds) {
            this.explicitIds = explicitIds;
        }

        @Override
        public final Builder explicitIds(Boolean explicitIds) {
            this.explicitIds = explicitIds;
            return this;
        }

        public final Integer getFileTransferUploadStreams() {
            return this.fileTransferUploadStreams;
        }

        public final void setFileTransferUploadStreams(Integer fileTransferUploadStreams) {
            this.fileTransferUploadStreams = fileTransferUploadStreams;
        }

        @Override
        public final Builder fileTransferUploadStreams(Integer fileTransferUploadStreams) {
            this.fileTransferUploadStreams = fileTransferUploadStreams;
            return this;
        }

        public final Integer getLoadTimeout() {
            return this.loadTimeout;
        }

        public final void setLoadTimeout(Integer loadTimeout) {
            this.loadTimeout = loadTimeout;
        }

        @Override
        public final Builder loadTimeout(Integer loadTimeout) {
            this.loadTimeout = loadTimeout;
            return this;
        }

        public final Integer getMaxFileSize() {
            return this.maxFileSize;
        }

        public final void setMaxFileSize(Integer maxFileSize) {
            this.maxFileSize = maxFileSize;
        }

        @Override
        public final Builder maxFileSize(Integer maxFileSize) {
            this.maxFileSize = maxFileSize;
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final Boolean getRemoveQuotes() {
            return this.removeQuotes;
        }

        public final void setRemoveQuotes(Boolean removeQuotes) {
            this.removeQuotes = removeQuotes;
        }

        @Override
        public final Builder removeQuotes(Boolean removeQuotes) {
            this.removeQuotes = removeQuotes;
            return this;
        }

        public final String getReplaceInvalidChars() {
            return this.replaceInvalidChars;
        }

        public final void setReplaceInvalidChars(String replaceInvalidChars) {
            this.replaceInvalidChars = replaceInvalidChars;
        }

        @Override
        public final Builder replaceInvalidChars(String replaceInvalidChars) {
            this.replaceInvalidChars = replaceInvalidChars;
            return this;
        }

        public final String getReplaceChars() {
            return this.replaceChars;
        }

        public final void setReplaceChars(String replaceChars) {
            this.replaceChars = replaceChars;
        }

        @Override
        public final Builder replaceChars(String replaceChars) {
            this.replaceChars = replaceChars;
            return this;
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final String getServerSideEncryptionKmsKeyId() {
            return this.serverSideEncryptionKmsKeyId;
        }

        public final void setServerSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId) {
            this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
        }

        @Override
        public final Builder serverSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId) {
            this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
            return this;
        }

        public final String getTimeFormat() {
            return this.timeFormat;
        }

        public final void setTimeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
        }

        @Override
        public final Builder timeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
            return this;
        }

        public final Boolean getTrimBlanks() {
            return this.trimBlanks;
        }

        public final void setTrimBlanks(Boolean trimBlanks) {
            this.trimBlanks = trimBlanks;
        }

        @Override
        public final Builder trimBlanks(Boolean trimBlanks) {
            this.trimBlanks = trimBlanks;
            return this;
        }

        public final Boolean getTruncateColumns() {
            return this.truncateColumns;
        }

        public final void setTruncateColumns(Boolean truncateColumns) {
            this.truncateColumns = truncateColumns;
        }

        @Override
        public final Builder truncateColumns(Boolean truncateColumns) {
            this.truncateColumns = truncateColumns;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final Integer getWriteBufferSize() {
            return this.writeBufferSize;
        }

        public final void setWriteBufferSize(Integer writeBufferSize) {
            this.writeBufferSize = writeBufferSize;
        }

        @Override
        public final Builder writeBufferSize(Integer writeBufferSize) {
            this.writeBufferSize = writeBufferSize;
            return this;
        }

        public final String getSecretsManagerAccessRoleArn() {
            return this.secretsManagerAccessRoleArn;
        }

        public final void setSecretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
        }

        @Override
        public final Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
            return this;
        }

        public final String getSecretsManagerSecretId() {
            return this.secretsManagerSecretId;
        }

        public final void setSecretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
        }

        @Override
        public final Builder secretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
            return this;
        }

        public RedshiftSettings build() {
            return new RedshiftSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftSettings> {
        public Builder acceptAnyDate(Boolean var1);

        public Builder afterConnectScript(String var1);

        public Builder bucketFolder(String var1);

        public Builder bucketName(String var1);

        public Builder caseSensitiveNames(Boolean var1);

        public Builder compUpdate(Boolean var1);

        public Builder connectionTimeout(Integer var1);

        public Builder databaseName(String var1);

        public Builder dateFormat(String var1);

        public Builder emptyAsNull(Boolean var1);

        public Builder encryptionMode(String var1);

        public Builder encryptionMode(EncryptionModeValue var1);

        public Builder explicitIds(Boolean var1);

        public Builder fileTransferUploadStreams(Integer var1);

        public Builder loadTimeout(Integer var1);

        public Builder maxFileSize(Integer var1);

        public Builder password(String var1);

        public Builder port(Integer var1);

        public Builder removeQuotes(Boolean var1);

        public Builder replaceInvalidChars(String var1);

        public Builder replaceChars(String var1);

        public Builder serverName(String var1);

        public Builder serviceAccessRoleArn(String var1);

        public Builder serverSideEncryptionKmsKeyId(String var1);

        public Builder timeFormat(String var1);

        public Builder trimBlanks(Boolean var1);

        public Builder truncateColumns(Boolean var1);

        public Builder username(String var1);

        public Builder writeBufferSize(Integer var1);

        public Builder secretsManagerAccessRoleArn(String var1);

        public Builder secretsManagerSecretId(String var1);
    }
}

