/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue;
import software.amazon.awssdk.services.databasemigration.model.CompressionTypeValue;
import software.amazon.awssdk.services.databasemigration.model.DataFormatValue;
import software.amazon.awssdk.services.databasemigration.model.DatePartitionDelimiterValue;
import software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue;
import software.amazon.awssdk.services.databasemigration.model.EncodingTypeValue;
import software.amazon.awssdk.services.databasemigration.model.EncryptionModeValue;
import software.amazon.awssdk.services.databasemigration.model.ParquetVersionValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Settings> {
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceAccessRoleArn").getter(S3Settings.getter(S3Settings::serviceAccessRoleArn)).setter(S3Settings.setter(Builder::serviceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build()}).build();
    private static final SdkField<String> EXTERNAL_TABLE_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalTableDefinition").getter(S3Settings.getter(S3Settings::externalTableDefinition)).setter(S3Settings.setter(Builder::externalTableDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalTableDefinition").build()}).build();
    private static final SdkField<String> CSV_ROW_DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CsvRowDelimiter").getter(S3Settings.getter(S3Settings::csvRowDelimiter)).setter(S3Settings.setter(Builder::csvRowDelimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvRowDelimiter").build()}).build();
    private static final SdkField<String> CSV_DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CsvDelimiter").getter(S3Settings.getter(S3Settings::csvDelimiter)).setter(S3Settings.setter(Builder::csvDelimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvDelimiter").build()}).build();
    private static final SdkField<String> BUCKET_FOLDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketFolder").getter(S3Settings.getter(S3Settings::bucketFolder)).setter(S3Settings.setter(Builder::bucketFolder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketFolder").build()}).build();
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketName").getter(S3Settings.getter(S3Settings::bucketName)).setter(S3Settings.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()}).build();
    private static final SdkField<String> COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompressionType").getter(S3Settings.getter(S3Settings::compressionTypeAsString)).setter(S3Settings.setter(Builder::compressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionType").build()}).build();
    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionMode").getter(S3Settings.getter(S3Settings::encryptionModeAsString)).setter(S3Settings.setter(Builder::encryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionMode").build()}).build();
    private static final SdkField<String> SERVER_SIDE_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerSideEncryptionKmsKeyId").getter(S3Settings.getter(S3Settings::serverSideEncryptionKmsKeyId)).setter(S3Settings.setter(Builder::serverSideEncryptionKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideEncryptionKmsKeyId").build()}).build();
    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataFormat").getter(S3Settings.getter(S3Settings::dataFormatAsString)).setter(S3Settings.setter(Builder::dataFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()}).build();
    private static final SdkField<String> ENCODING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncodingType").getter(S3Settings.getter(S3Settings::encodingTypeAsString)).setter(S3Settings.setter(Builder::encodingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncodingType").build()}).build();
    private static final SdkField<Integer> DICT_PAGE_SIZE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DictPageSizeLimit").getter(S3Settings.getter(S3Settings::dictPageSizeLimit)).setter(S3Settings.setter(Builder::dictPageSizeLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DictPageSizeLimit").build()}).build();
    private static final SdkField<Integer> ROW_GROUP_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RowGroupLength").getter(S3Settings.getter(S3Settings::rowGroupLength)).setter(S3Settings.setter(Builder::rowGroupLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowGroupLength").build()}).build();
    private static final SdkField<Integer> DATA_PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DataPageSize").getter(S3Settings.getter(S3Settings::dataPageSize)).setter(S3Settings.setter(Builder::dataPageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPageSize").build()}).build();
    private static final SdkField<String> PARQUET_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParquetVersion").getter(S3Settings.getter(S3Settings::parquetVersionAsString)).setter(S3Settings.setter(Builder::parquetVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParquetVersion").build()}).build();
    private static final SdkField<Boolean> ENABLE_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableStatistics").getter(S3Settings.getter(S3Settings::enableStatistics)).setter(S3Settings.setter(Builder::enableStatistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableStatistics").build()}).build();
    private static final SdkField<Boolean> INCLUDE_OP_FOR_FULL_LOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeOpForFullLoad").getter(S3Settings.getter(S3Settings::includeOpForFullLoad)).setter(S3Settings.setter(Builder::includeOpForFullLoad)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeOpForFullLoad").build()}).build();
    private static final SdkField<Boolean> CDC_INSERTS_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CdcInsertsOnly").getter(S3Settings.getter(S3Settings::cdcInsertsOnly)).setter(S3Settings.setter(Builder::cdcInsertsOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcInsertsOnly").build()}).build();
    private static final SdkField<String> TIMESTAMP_COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimestampColumnName").getter(S3Settings.getter(S3Settings::timestampColumnName)).setter(S3Settings.setter(Builder::timestampColumnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampColumnName").build()}).build();
    private static final SdkField<Boolean> PARQUET_TIMESTAMP_IN_MILLISECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ParquetTimestampInMillisecond").getter(S3Settings.getter(S3Settings::parquetTimestampInMillisecond)).setter(S3Settings.setter(Builder::parquetTimestampInMillisecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParquetTimestampInMillisecond").build()}).build();
    private static final SdkField<Boolean> CDC_INSERTS_AND_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CdcInsertsAndUpdates").getter(S3Settings.getter(S3Settings::cdcInsertsAndUpdates)).setter(S3Settings.setter(Builder::cdcInsertsAndUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcInsertsAndUpdates").build()}).build();
    private static final SdkField<Boolean> DATE_PARTITION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DatePartitionEnabled").getter(S3Settings.getter(S3Settings::datePartitionEnabled)).setter(S3Settings.setter(Builder::datePartitionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatePartitionEnabled").build()}).build();
    private static final SdkField<String> DATE_PARTITION_SEQUENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatePartitionSequence").getter(S3Settings.getter(S3Settings::datePartitionSequenceAsString)).setter(S3Settings.setter(Builder::datePartitionSequence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatePartitionSequence").build()}).build();
    private static final SdkField<String> DATE_PARTITION_DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatePartitionDelimiter").getter(S3Settings.getter(S3Settings::datePartitionDelimiterAsString)).setter(S3Settings.setter(Builder::datePartitionDelimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatePartitionDelimiter").build()}).build();
    private static final SdkField<Boolean> USE_CSV_NO_SUP_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseCsvNoSupValue").getter(S3Settings.getter(S3Settings::useCsvNoSupValue)).setter(S3Settings.setter(Builder::useCsvNoSupValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCsvNoSupValue").build()}).build();
    private static final SdkField<String> CSV_NO_SUP_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CsvNoSupValue").getter(S3Settings.getter(S3Settings::csvNoSupValue)).setter(S3Settings.setter(Builder::csvNoSupValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvNoSupValue").build()}).build();
    private static final SdkField<Boolean> PRESERVE_TRANSACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PreserveTransactions").getter(S3Settings.getter(S3Settings::preserveTransactions)).setter(S3Settings.setter(Builder::preserveTransactions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreserveTransactions").build()}).build();
    private static final SdkField<String> CDC_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CdcPath").getter(S3Settings.getter(S3Settings::cdcPath)).setter(S3Settings.setter(Builder::cdcPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcPath").build()}).build();
    private static final SdkField<Boolean> USE_TASK_START_TIME_FOR_FULL_LOAD_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseTaskStartTimeForFullLoadTimestamp").getter(S3Settings.getter(S3Settings::useTaskStartTimeForFullLoadTimestamp)).setter(S3Settings.setter(Builder::useTaskStartTimeForFullLoadTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseTaskStartTimeForFullLoadTimestamp").build()}).build();
    private static final SdkField<String> CANNED_ACL_FOR_OBJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CannedAclForObjects").getter(S3Settings.getter(S3Settings::cannedAclForObjectsAsString)).setter(S3Settings.setter(Builder::cannedAclForObjects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CannedAclForObjects").build()}).build();
    private static final SdkField<Boolean> ADD_COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AddColumnName").getter(S3Settings.getter(S3Settings::addColumnName)).setter(S3Settings.setter(Builder::addColumnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddColumnName").build()}).build();
    private static final SdkField<Integer> CDC_MAX_BATCH_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CdcMaxBatchInterval").getter(S3Settings.getter(S3Settings::cdcMaxBatchInterval)).setter(S3Settings.setter(Builder::cdcMaxBatchInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcMaxBatchInterval").build()}).build();
    private static final SdkField<Integer> CDC_MIN_FILE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CdcMinFileSize").getter(S3Settings.getter(S3Settings::cdcMinFileSize)).setter(S3Settings.setter(Builder::cdcMinFileSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcMinFileSize").build()}).build();
    private static final SdkField<String> CSV_NULL_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CsvNullValue").getter(S3Settings.getter(S3Settings::csvNullValue)).setter(S3Settings.setter(Builder::csvNullValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvNullValue").build()}).build();
    private static final SdkField<Integer> IGNORE_HEADER_ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IgnoreHeaderRows").getter(S3Settings.getter(S3Settings::ignoreHeaderRows)).setter(S3Settings.setter(Builder::ignoreHeaderRows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnoreHeaderRows").build()}).build();
    private static final SdkField<Integer> MAX_FILE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxFileSize").getter(S3Settings.getter(S3Settings::maxFileSize)).setter(S3Settings.setter(Builder::maxFileSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFileSize").build()}).build();
    private static final SdkField<Boolean> RFC4180_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Rfc4180").getter(S3Settings.getter(S3Settings::rfc4180)).setter(S3Settings.setter(Builder::rfc4180)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rfc4180").build()}).build();
    private static final SdkField<String> DATE_PARTITION_TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatePartitionTimezone").getter(S3Settings.getter(S3Settings::datePartitionTimezone)).setter(S3Settings.setter(Builder::datePartitionTimezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatePartitionTimezone").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCESS_ROLE_ARN_FIELD, EXTERNAL_TABLE_DEFINITION_FIELD, CSV_ROW_DELIMITER_FIELD, CSV_DELIMITER_FIELD, BUCKET_FOLDER_FIELD, BUCKET_NAME_FIELD, COMPRESSION_TYPE_FIELD, ENCRYPTION_MODE_FIELD, SERVER_SIDE_ENCRYPTION_KMS_KEY_ID_FIELD, DATA_FORMAT_FIELD, ENCODING_TYPE_FIELD, DICT_PAGE_SIZE_LIMIT_FIELD, ROW_GROUP_LENGTH_FIELD, DATA_PAGE_SIZE_FIELD, PARQUET_VERSION_FIELD, ENABLE_STATISTICS_FIELD, INCLUDE_OP_FOR_FULL_LOAD_FIELD, CDC_INSERTS_ONLY_FIELD, TIMESTAMP_COLUMN_NAME_FIELD, PARQUET_TIMESTAMP_IN_MILLISECOND_FIELD, CDC_INSERTS_AND_UPDATES_FIELD, DATE_PARTITION_ENABLED_FIELD, DATE_PARTITION_SEQUENCE_FIELD, DATE_PARTITION_DELIMITER_FIELD, USE_CSV_NO_SUP_VALUE_FIELD, CSV_NO_SUP_VALUE_FIELD, PRESERVE_TRANSACTIONS_FIELD, CDC_PATH_FIELD, USE_TASK_START_TIME_FOR_FULL_LOAD_TIMESTAMP_FIELD, CANNED_ACL_FOR_OBJECTS_FIELD, ADD_COLUMN_NAME_FIELD, CDC_MAX_BATCH_INTERVAL_FIELD, CDC_MIN_FILE_SIZE_FIELD, CSV_NULL_VALUE_FIELD, IGNORE_HEADER_ROWS_FIELD, MAX_FILE_SIZE_FIELD, RFC4180_FIELD, DATE_PARTITION_TIMEZONE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceAccessRoleArn;
    private final String externalTableDefinition;
    private final String csvRowDelimiter;
    private final String csvDelimiter;
    private final String bucketFolder;
    private final String bucketName;
    private final String compressionType;
    private final String encryptionMode;
    private final String serverSideEncryptionKmsKeyId;
    private final String dataFormat;
    private final String encodingType;
    private final Integer dictPageSizeLimit;
    private final Integer rowGroupLength;
    private final Integer dataPageSize;
    private final String parquetVersion;
    private final Boolean enableStatistics;
    private final Boolean includeOpForFullLoad;
    private final Boolean cdcInsertsOnly;
    private final String timestampColumnName;
    private final Boolean parquetTimestampInMillisecond;
    private final Boolean cdcInsertsAndUpdates;
    private final Boolean datePartitionEnabled;
    private final String datePartitionSequence;
    private final String datePartitionDelimiter;
    private final Boolean useCsvNoSupValue;
    private final String csvNoSupValue;
    private final Boolean preserveTransactions;
    private final String cdcPath;
    private final Boolean useTaskStartTimeForFullLoadTimestamp;
    private final String cannedAclForObjects;
    private final Boolean addColumnName;
    private final Integer cdcMaxBatchInterval;
    private final Integer cdcMinFileSize;
    private final String csvNullValue;
    private final Integer ignoreHeaderRows;
    private final Integer maxFileSize;
    private final Boolean rfc4180;
    private final String datePartitionTimezone;

    private S3Settings(BuilderImpl builder) {
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.externalTableDefinition = builder.externalTableDefinition;
        this.csvRowDelimiter = builder.csvRowDelimiter;
        this.csvDelimiter = builder.csvDelimiter;
        this.bucketFolder = builder.bucketFolder;
        this.bucketName = builder.bucketName;
        this.compressionType = builder.compressionType;
        this.encryptionMode = builder.encryptionMode;
        this.serverSideEncryptionKmsKeyId = builder.serverSideEncryptionKmsKeyId;
        this.dataFormat = builder.dataFormat;
        this.encodingType = builder.encodingType;
        this.dictPageSizeLimit = builder.dictPageSizeLimit;
        this.rowGroupLength = builder.rowGroupLength;
        this.dataPageSize = builder.dataPageSize;
        this.parquetVersion = builder.parquetVersion;
        this.enableStatistics = builder.enableStatistics;
        this.includeOpForFullLoad = builder.includeOpForFullLoad;
        this.cdcInsertsOnly = builder.cdcInsertsOnly;
        this.timestampColumnName = builder.timestampColumnName;
        this.parquetTimestampInMillisecond = builder.parquetTimestampInMillisecond;
        this.cdcInsertsAndUpdates = builder.cdcInsertsAndUpdates;
        this.datePartitionEnabled = builder.datePartitionEnabled;
        this.datePartitionSequence = builder.datePartitionSequence;
        this.datePartitionDelimiter = builder.datePartitionDelimiter;
        this.useCsvNoSupValue = builder.useCsvNoSupValue;
        this.csvNoSupValue = builder.csvNoSupValue;
        this.preserveTransactions = builder.preserveTransactions;
        this.cdcPath = builder.cdcPath;
        this.useTaskStartTimeForFullLoadTimestamp = builder.useTaskStartTimeForFullLoadTimestamp;
        this.cannedAclForObjects = builder.cannedAclForObjects;
        this.addColumnName = builder.addColumnName;
        this.cdcMaxBatchInterval = builder.cdcMaxBatchInterval;
        this.cdcMinFileSize = builder.cdcMinFileSize;
        this.csvNullValue = builder.csvNullValue;
        this.ignoreHeaderRows = builder.ignoreHeaderRows;
        this.maxFileSize = builder.maxFileSize;
        this.rfc4180 = builder.rfc4180;
        this.datePartitionTimezone = builder.datePartitionTimezone;
    }

    public final String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public final String externalTableDefinition() {
        return this.externalTableDefinition;
    }

    public final String csvRowDelimiter() {
        return this.csvRowDelimiter;
    }

    public final String csvDelimiter() {
        return this.csvDelimiter;
    }

    public final String bucketFolder() {
        return this.bucketFolder;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final CompressionTypeValue compressionType() {
        return CompressionTypeValue.fromValue(this.compressionType);
    }

    public final String compressionTypeAsString() {
        return this.compressionType;
    }

    public final EncryptionModeValue encryptionMode() {
        return EncryptionModeValue.fromValue(this.encryptionMode);
    }

    public final String encryptionModeAsString() {
        return this.encryptionMode;
    }

    public final String serverSideEncryptionKmsKeyId() {
        return this.serverSideEncryptionKmsKeyId;
    }

    public final DataFormatValue dataFormat() {
        return DataFormatValue.fromValue(this.dataFormat);
    }

    public final String dataFormatAsString() {
        return this.dataFormat;
    }

    public final EncodingTypeValue encodingType() {
        return EncodingTypeValue.fromValue(this.encodingType);
    }

    public final String encodingTypeAsString() {
        return this.encodingType;
    }

    public final Integer dictPageSizeLimit() {
        return this.dictPageSizeLimit;
    }

    public final Integer rowGroupLength() {
        return this.rowGroupLength;
    }

    public final Integer dataPageSize() {
        return this.dataPageSize;
    }

    public final ParquetVersionValue parquetVersion() {
        return ParquetVersionValue.fromValue(this.parquetVersion);
    }

    public final String parquetVersionAsString() {
        return this.parquetVersion;
    }

    public final Boolean enableStatistics() {
        return this.enableStatistics;
    }

    public final Boolean includeOpForFullLoad() {
        return this.includeOpForFullLoad;
    }

    public final Boolean cdcInsertsOnly() {
        return this.cdcInsertsOnly;
    }

    public final String timestampColumnName() {
        return this.timestampColumnName;
    }

    public final Boolean parquetTimestampInMillisecond() {
        return this.parquetTimestampInMillisecond;
    }

    public final Boolean cdcInsertsAndUpdates() {
        return this.cdcInsertsAndUpdates;
    }

    public final Boolean datePartitionEnabled() {
        return this.datePartitionEnabled;
    }

    public final DatePartitionSequenceValue datePartitionSequence() {
        return DatePartitionSequenceValue.fromValue(this.datePartitionSequence);
    }

    public final String datePartitionSequenceAsString() {
        return this.datePartitionSequence;
    }

    public final DatePartitionDelimiterValue datePartitionDelimiter() {
        return DatePartitionDelimiterValue.fromValue(this.datePartitionDelimiter);
    }

    public final String datePartitionDelimiterAsString() {
        return this.datePartitionDelimiter;
    }

    public final Boolean useCsvNoSupValue() {
        return this.useCsvNoSupValue;
    }

    public final String csvNoSupValue() {
        return this.csvNoSupValue;
    }

    public final Boolean preserveTransactions() {
        return this.preserveTransactions;
    }

    public final String cdcPath() {
        return this.cdcPath;
    }

    public final Boolean useTaskStartTimeForFullLoadTimestamp() {
        return this.useTaskStartTimeForFullLoadTimestamp;
    }

    public final CannedAclForObjectsValue cannedAclForObjects() {
        return CannedAclForObjectsValue.fromValue(this.cannedAclForObjects);
    }

    public final String cannedAclForObjectsAsString() {
        return this.cannedAclForObjects;
    }

    public final Boolean addColumnName() {
        return this.addColumnName;
    }

    public final Integer cdcMaxBatchInterval() {
        return this.cdcMaxBatchInterval;
    }

    public final Integer cdcMinFileSize() {
        return this.cdcMinFileSize;
    }

    public final String csvNullValue() {
        return this.csvNullValue;
    }

    public final Integer ignoreHeaderRows() {
        return this.ignoreHeaderRows;
    }

    public final Integer maxFileSize() {
        return this.maxFileSize;
    }

    public final Boolean rfc4180() {
        return this.rfc4180;
    }

    public final String datePartitionTimezone() {
        return this.datePartitionTimezone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalTableDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.csvRowDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.csvDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketFolder());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideEncryptionKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encodingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dictPageSizeLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowGroupLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.parquetVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeOpForFullLoad());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcInsertsOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parquetTimestampInMillisecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcInsertsAndUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(this.datePartitionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.datePartitionSequenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.datePartitionDelimiterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.useCsvNoSupValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.csvNoSupValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.preserveTransactions());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.useTaskStartTimeForFullLoadTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.cannedAclForObjectsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.addColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcMaxBatchInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcMinFileSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.csvNullValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.ignoreHeaderRows());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFileSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.rfc4180());
        hashCode = 31 * hashCode + Objects.hashCode(this.datePartitionTimezone());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Settings)) {
            return false;
        }
        S3Settings other = (S3Settings)obj;
        return Objects.equals(this.serviceAccessRoleArn(), other.serviceAccessRoleArn()) && Objects.equals(this.externalTableDefinition(), other.externalTableDefinition()) && Objects.equals(this.csvRowDelimiter(), other.csvRowDelimiter()) && Objects.equals(this.csvDelimiter(), other.csvDelimiter()) && Objects.equals(this.bucketFolder(), other.bucketFolder()) && Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.compressionTypeAsString(), other.compressionTypeAsString()) && Objects.equals(this.encryptionModeAsString(), other.encryptionModeAsString()) && Objects.equals(this.serverSideEncryptionKmsKeyId(), other.serverSideEncryptionKmsKeyId()) && Objects.equals(this.dataFormatAsString(), other.dataFormatAsString()) && Objects.equals(this.encodingTypeAsString(), other.encodingTypeAsString()) && Objects.equals(this.dictPageSizeLimit(), other.dictPageSizeLimit()) && Objects.equals(this.rowGroupLength(), other.rowGroupLength()) && Objects.equals(this.dataPageSize(), other.dataPageSize()) && Objects.equals(this.parquetVersionAsString(), other.parquetVersionAsString()) && Objects.equals(this.enableStatistics(), other.enableStatistics()) && Objects.equals(this.includeOpForFullLoad(), other.includeOpForFullLoad()) && Objects.equals(this.cdcInsertsOnly(), other.cdcInsertsOnly()) && Objects.equals(this.timestampColumnName(), other.timestampColumnName()) && Objects.equals(this.parquetTimestampInMillisecond(), other.parquetTimestampInMillisecond()) && Objects.equals(this.cdcInsertsAndUpdates(), other.cdcInsertsAndUpdates()) && Objects.equals(this.datePartitionEnabled(), other.datePartitionEnabled()) && Objects.equals(this.datePartitionSequenceAsString(), other.datePartitionSequenceAsString()) && Objects.equals(this.datePartitionDelimiterAsString(), other.datePartitionDelimiterAsString()) && Objects.equals(this.useCsvNoSupValue(), other.useCsvNoSupValue()) && Objects.equals(this.csvNoSupValue(), other.csvNoSupValue()) && Objects.equals(this.preserveTransactions(), other.preserveTransactions()) && Objects.equals(this.cdcPath(), other.cdcPath()) && Objects.equals(this.useTaskStartTimeForFullLoadTimestamp(), other.useTaskStartTimeForFullLoadTimestamp()) && Objects.equals(this.cannedAclForObjectsAsString(), other.cannedAclForObjectsAsString()) && Objects.equals(this.addColumnName(), other.addColumnName()) && Objects.equals(this.cdcMaxBatchInterval(), other.cdcMaxBatchInterval()) && Objects.equals(this.cdcMinFileSize(), other.cdcMinFileSize()) && Objects.equals(this.csvNullValue(), other.csvNullValue()) && Objects.equals(this.ignoreHeaderRows(), other.ignoreHeaderRows()) && Objects.equals(this.maxFileSize(), other.maxFileSize()) && Objects.equals(this.rfc4180(), other.rfc4180()) && Objects.equals(this.datePartitionTimezone(), other.datePartitionTimezone());
    }

    public final String toString() {
        return ToString.builder((String)"S3Settings").add("ServiceAccessRoleArn", (Object)this.serviceAccessRoleArn()).add("ExternalTableDefinition", (Object)this.externalTableDefinition()).add("CsvRowDelimiter", (Object)this.csvRowDelimiter()).add("CsvDelimiter", (Object)this.csvDelimiter()).add("BucketFolder", (Object)this.bucketFolder()).add("BucketName", (Object)this.bucketName()).add("CompressionType", (Object)this.compressionTypeAsString()).add("EncryptionMode", (Object)this.encryptionModeAsString()).add("ServerSideEncryptionKmsKeyId", (Object)this.serverSideEncryptionKmsKeyId()).add("DataFormat", (Object)this.dataFormatAsString()).add("EncodingType", (Object)this.encodingTypeAsString()).add("DictPageSizeLimit", (Object)this.dictPageSizeLimit()).add("RowGroupLength", (Object)this.rowGroupLength()).add("DataPageSize", (Object)this.dataPageSize()).add("ParquetVersion", (Object)this.parquetVersionAsString()).add("EnableStatistics", (Object)this.enableStatistics()).add("IncludeOpForFullLoad", (Object)this.includeOpForFullLoad()).add("CdcInsertsOnly", (Object)this.cdcInsertsOnly()).add("TimestampColumnName", (Object)this.timestampColumnName()).add("ParquetTimestampInMillisecond", (Object)this.parquetTimestampInMillisecond()).add("CdcInsertsAndUpdates", (Object)this.cdcInsertsAndUpdates()).add("DatePartitionEnabled", (Object)this.datePartitionEnabled()).add("DatePartitionSequence", (Object)this.datePartitionSequenceAsString()).add("DatePartitionDelimiter", (Object)this.datePartitionDelimiterAsString()).add("UseCsvNoSupValue", (Object)this.useCsvNoSupValue()).add("CsvNoSupValue", (Object)this.csvNoSupValue()).add("PreserveTransactions", (Object)this.preserveTransactions()).add("CdcPath", (Object)this.cdcPath()).add("UseTaskStartTimeForFullLoadTimestamp", (Object)this.useTaskStartTimeForFullLoadTimestamp()).add("CannedAclForObjects", (Object)this.cannedAclForObjectsAsString()).add("AddColumnName", (Object)this.addColumnName()).add("CdcMaxBatchInterval", (Object)this.cdcMaxBatchInterval()).add("CdcMinFileSize", (Object)this.cdcMinFileSize()).add("CsvNullValue", (Object)this.csvNullValue()).add("IgnoreHeaderRows", (Object)this.ignoreHeaderRows()).add("MaxFileSize", (Object)this.maxFileSize()).add("Rfc4180", (Object)this.rfc4180()).add("DatePartitionTimezone", (Object)this.datePartitionTimezone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessRoleArn()));
            }
            case "ExternalTableDefinition": {
                return Optional.ofNullable(clazz.cast(this.externalTableDefinition()));
            }
            case "CsvRowDelimiter": {
                return Optional.ofNullable(clazz.cast(this.csvRowDelimiter()));
            }
            case "CsvDelimiter": {
                return Optional.ofNullable(clazz.cast(this.csvDelimiter()));
            }
            case "BucketFolder": {
                return Optional.ofNullable(clazz.cast(this.bucketFolder()));
            }
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "CompressionType": {
                return Optional.ofNullable(clazz.cast(this.compressionTypeAsString()));
            }
            case "EncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.encryptionModeAsString()));
            }
            case "ServerSideEncryptionKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.serverSideEncryptionKmsKeyId()));
            }
            case "DataFormat": {
                return Optional.ofNullable(clazz.cast(this.dataFormatAsString()));
            }
            case "EncodingType": {
                return Optional.ofNullable(clazz.cast(this.encodingTypeAsString()));
            }
            case "DictPageSizeLimit": {
                return Optional.ofNullable(clazz.cast(this.dictPageSizeLimit()));
            }
            case "RowGroupLength": {
                return Optional.ofNullable(clazz.cast(this.rowGroupLength()));
            }
            case "DataPageSize": {
                return Optional.ofNullable(clazz.cast(this.dataPageSize()));
            }
            case "ParquetVersion": {
                return Optional.ofNullable(clazz.cast(this.parquetVersionAsString()));
            }
            case "EnableStatistics": {
                return Optional.ofNullable(clazz.cast(this.enableStatistics()));
            }
            case "IncludeOpForFullLoad": {
                return Optional.ofNullable(clazz.cast(this.includeOpForFullLoad()));
            }
            case "CdcInsertsOnly": {
                return Optional.ofNullable(clazz.cast(this.cdcInsertsOnly()));
            }
            case "TimestampColumnName": {
                return Optional.ofNullable(clazz.cast(this.timestampColumnName()));
            }
            case "ParquetTimestampInMillisecond": {
                return Optional.ofNullable(clazz.cast(this.parquetTimestampInMillisecond()));
            }
            case "CdcInsertsAndUpdates": {
                return Optional.ofNullable(clazz.cast(this.cdcInsertsAndUpdates()));
            }
            case "DatePartitionEnabled": {
                return Optional.ofNullable(clazz.cast(this.datePartitionEnabled()));
            }
            case "DatePartitionSequence": {
                return Optional.ofNullable(clazz.cast(this.datePartitionSequenceAsString()));
            }
            case "DatePartitionDelimiter": {
                return Optional.ofNullable(clazz.cast(this.datePartitionDelimiterAsString()));
            }
            case "UseCsvNoSupValue": {
                return Optional.ofNullable(clazz.cast(this.useCsvNoSupValue()));
            }
            case "CsvNoSupValue": {
                return Optional.ofNullable(clazz.cast(this.csvNoSupValue()));
            }
            case "PreserveTransactions": {
                return Optional.ofNullable(clazz.cast(this.preserveTransactions()));
            }
            case "CdcPath": {
                return Optional.ofNullable(clazz.cast(this.cdcPath()));
            }
            case "UseTaskStartTimeForFullLoadTimestamp": {
                return Optional.ofNullable(clazz.cast(this.useTaskStartTimeForFullLoadTimestamp()));
            }
            case "CannedAclForObjects": {
                return Optional.ofNullable(clazz.cast(this.cannedAclForObjectsAsString()));
            }
            case "AddColumnName": {
                return Optional.ofNullable(clazz.cast(this.addColumnName()));
            }
            case "CdcMaxBatchInterval": {
                return Optional.ofNullable(clazz.cast(this.cdcMaxBatchInterval()));
            }
            case "CdcMinFileSize": {
                return Optional.ofNullable(clazz.cast(this.cdcMinFileSize()));
            }
            case "CsvNullValue": {
                return Optional.ofNullable(clazz.cast(this.csvNullValue()));
            }
            case "IgnoreHeaderRows": {
                return Optional.ofNullable(clazz.cast(this.ignoreHeaderRows()));
            }
            case "MaxFileSize": {
                return Optional.ofNullable(clazz.cast(this.maxFileSize()));
            }
            case "Rfc4180": {
                return Optional.ofNullable(clazz.cast(this.rfc4180()));
            }
            case "DatePartitionTimezone": {
                return Optional.ofNullable(clazz.cast(this.datePartitionTimezone()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Settings, T> g) {
        return obj -> g.apply((S3Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceAccessRoleArn;
        private String externalTableDefinition;
        private String csvRowDelimiter;
        private String csvDelimiter;
        private String bucketFolder;
        private String bucketName;
        private String compressionType;
        private String encryptionMode;
        private String serverSideEncryptionKmsKeyId;
        private String dataFormat;
        private String encodingType;
        private Integer dictPageSizeLimit;
        private Integer rowGroupLength;
        private Integer dataPageSize;
        private String parquetVersion;
        private Boolean enableStatistics;
        private Boolean includeOpForFullLoad;
        private Boolean cdcInsertsOnly;
        private String timestampColumnName;
        private Boolean parquetTimestampInMillisecond;
        private Boolean cdcInsertsAndUpdates;
        private Boolean datePartitionEnabled;
        private String datePartitionSequence;
        private String datePartitionDelimiter;
        private Boolean useCsvNoSupValue;
        private String csvNoSupValue;
        private Boolean preserveTransactions;
        private String cdcPath;
        private Boolean useTaskStartTimeForFullLoadTimestamp;
        private String cannedAclForObjects;
        private Boolean addColumnName;
        private Integer cdcMaxBatchInterval;
        private Integer cdcMinFileSize;
        private String csvNullValue;
        private Integer ignoreHeaderRows;
        private Integer maxFileSize;
        private Boolean rfc4180;
        private String datePartitionTimezone;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Settings model) {
            this.serviceAccessRoleArn(model.serviceAccessRoleArn);
            this.externalTableDefinition(model.externalTableDefinition);
            this.csvRowDelimiter(model.csvRowDelimiter);
            this.csvDelimiter(model.csvDelimiter);
            this.bucketFolder(model.bucketFolder);
            this.bucketName(model.bucketName);
            this.compressionType(model.compressionType);
            this.encryptionMode(model.encryptionMode);
            this.serverSideEncryptionKmsKeyId(model.serverSideEncryptionKmsKeyId);
            this.dataFormat(model.dataFormat);
            this.encodingType(model.encodingType);
            this.dictPageSizeLimit(model.dictPageSizeLimit);
            this.rowGroupLength(model.rowGroupLength);
            this.dataPageSize(model.dataPageSize);
            this.parquetVersion(model.parquetVersion);
            this.enableStatistics(model.enableStatistics);
            this.includeOpForFullLoad(model.includeOpForFullLoad);
            this.cdcInsertsOnly(model.cdcInsertsOnly);
            this.timestampColumnName(model.timestampColumnName);
            this.parquetTimestampInMillisecond(model.parquetTimestampInMillisecond);
            this.cdcInsertsAndUpdates(model.cdcInsertsAndUpdates);
            this.datePartitionEnabled(model.datePartitionEnabled);
            this.datePartitionSequence(model.datePartitionSequence);
            this.datePartitionDelimiter(model.datePartitionDelimiter);
            this.useCsvNoSupValue(model.useCsvNoSupValue);
            this.csvNoSupValue(model.csvNoSupValue);
            this.preserveTransactions(model.preserveTransactions);
            this.cdcPath(model.cdcPath);
            this.useTaskStartTimeForFullLoadTimestamp(model.useTaskStartTimeForFullLoadTimestamp);
            this.cannedAclForObjects(model.cannedAclForObjects);
            this.addColumnName(model.addColumnName);
            this.cdcMaxBatchInterval(model.cdcMaxBatchInterval);
            this.cdcMinFileSize(model.cdcMinFileSize);
            this.csvNullValue(model.csvNullValue);
            this.ignoreHeaderRows(model.ignoreHeaderRows);
            this.maxFileSize(model.maxFileSize);
            this.rfc4180(model.rfc4180);
            this.datePartitionTimezone(model.datePartitionTimezone);
        }

        public final String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        @Override
        @Transient
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final String getExternalTableDefinition() {
            return this.externalTableDefinition;
        }

        public final void setExternalTableDefinition(String externalTableDefinition) {
            this.externalTableDefinition = externalTableDefinition;
        }

        @Override
        @Transient
        public final Builder externalTableDefinition(String externalTableDefinition) {
            this.externalTableDefinition = externalTableDefinition;
            return this;
        }

        public final String getCsvRowDelimiter() {
            return this.csvRowDelimiter;
        }

        public final void setCsvRowDelimiter(String csvRowDelimiter) {
            this.csvRowDelimiter = csvRowDelimiter;
        }

        @Override
        @Transient
        public final Builder csvRowDelimiter(String csvRowDelimiter) {
            this.csvRowDelimiter = csvRowDelimiter;
            return this;
        }

        public final String getCsvDelimiter() {
            return this.csvDelimiter;
        }

        public final void setCsvDelimiter(String csvDelimiter) {
            this.csvDelimiter = csvDelimiter;
        }

        @Override
        @Transient
        public final Builder csvDelimiter(String csvDelimiter) {
            this.csvDelimiter = csvDelimiter;
            return this;
        }

        public final String getBucketFolder() {
            return this.bucketFolder;
        }

        public final void setBucketFolder(String bucketFolder) {
            this.bucketFolder = bucketFolder;
        }

        @Override
        @Transient
        public final Builder bucketFolder(String bucketFolder) {
            this.bucketFolder = bucketFolder;
            return this;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        @Transient
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getCompressionType() {
            return this.compressionType;
        }

        public final void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        @Override
        @Transient
        public final Builder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        @Transient
        public final Builder compressionType(CompressionTypeValue compressionType) {
            this.compressionType(compressionType == null ? null : compressionType.toString());
            return this;
        }

        public final String getEncryptionMode() {
            return this.encryptionMode;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        @Override
        @Transient
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        @Override
        @Transient
        public final Builder encryptionMode(EncryptionModeValue encryptionMode) {
            this.encryptionMode(encryptionMode == null ? null : encryptionMode.toString());
            return this;
        }

        public final String getServerSideEncryptionKmsKeyId() {
            return this.serverSideEncryptionKmsKeyId;
        }

        public final void setServerSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId) {
            this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
        }

        @Override
        @Transient
        public final Builder serverSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId) {
            this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
            return this;
        }

        public final String getDataFormat() {
            return this.dataFormat;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        @Override
        @Transient
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder dataFormat(DataFormatValue dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final String getEncodingType() {
            return this.encodingType;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        @Override
        @Transient
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        @Transient
        public final Builder encodingType(EncodingTypeValue encodingType) {
            this.encodingType(encodingType == null ? null : encodingType.toString());
            return this;
        }

        public final Integer getDictPageSizeLimit() {
            return this.dictPageSizeLimit;
        }

        public final void setDictPageSizeLimit(Integer dictPageSizeLimit) {
            this.dictPageSizeLimit = dictPageSizeLimit;
        }

        @Override
        @Transient
        public final Builder dictPageSizeLimit(Integer dictPageSizeLimit) {
            this.dictPageSizeLimit = dictPageSizeLimit;
            return this;
        }

        public final Integer getRowGroupLength() {
            return this.rowGroupLength;
        }

        public final void setRowGroupLength(Integer rowGroupLength) {
            this.rowGroupLength = rowGroupLength;
        }

        @Override
        @Transient
        public final Builder rowGroupLength(Integer rowGroupLength) {
            this.rowGroupLength = rowGroupLength;
            return this;
        }

        public final Integer getDataPageSize() {
            return this.dataPageSize;
        }

        public final void setDataPageSize(Integer dataPageSize) {
            this.dataPageSize = dataPageSize;
        }

        @Override
        @Transient
        public final Builder dataPageSize(Integer dataPageSize) {
            this.dataPageSize = dataPageSize;
            return this;
        }

        public final String getParquetVersion() {
            return this.parquetVersion;
        }

        public final void setParquetVersion(String parquetVersion) {
            this.parquetVersion = parquetVersion;
        }

        @Override
        @Transient
        public final Builder parquetVersion(String parquetVersion) {
            this.parquetVersion = parquetVersion;
            return this;
        }

        @Override
        @Transient
        public final Builder parquetVersion(ParquetVersionValue parquetVersion) {
            this.parquetVersion(parquetVersion == null ? null : parquetVersion.toString());
            return this;
        }

        public final Boolean getEnableStatistics() {
            return this.enableStatistics;
        }

        public final void setEnableStatistics(Boolean enableStatistics) {
            this.enableStatistics = enableStatistics;
        }

        @Override
        @Transient
        public final Builder enableStatistics(Boolean enableStatistics) {
            this.enableStatistics = enableStatistics;
            return this;
        }

        public final Boolean getIncludeOpForFullLoad() {
            return this.includeOpForFullLoad;
        }

        public final void setIncludeOpForFullLoad(Boolean includeOpForFullLoad) {
            this.includeOpForFullLoad = includeOpForFullLoad;
        }

        @Override
        @Transient
        public final Builder includeOpForFullLoad(Boolean includeOpForFullLoad) {
            this.includeOpForFullLoad = includeOpForFullLoad;
            return this;
        }

        public final Boolean getCdcInsertsOnly() {
            return this.cdcInsertsOnly;
        }

        public final void setCdcInsertsOnly(Boolean cdcInsertsOnly) {
            this.cdcInsertsOnly = cdcInsertsOnly;
        }

        @Override
        @Transient
        public final Builder cdcInsertsOnly(Boolean cdcInsertsOnly) {
            this.cdcInsertsOnly = cdcInsertsOnly;
            return this;
        }

        public final String getTimestampColumnName() {
            return this.timestampColumnName;
        }

        public final void setTimestampColumnName(String timestampColumnName) {
            this.timestampColumnName = timestampColumnName;
        }

        @Override
        @Transient
        public final Builder timestampColumnName(String timestampColumnName) {
            this.timestampColumnName = timestampColumnName;
            return this;
        }

        public final Boolean getParquetTimestampInMillisecond() {
            return this.parquetTimestampInMillisecond;
        }

        public final void setParquetTimestampInMillisecond(Boolean parquetTimestampInMillisecond) {
            this.parquetTimestampInMillisecond = parquetTimestampInMillisecond;
        }

        @Override
        @Transient
        public final Builder parquetTimestampInMillisecond(Boolean parquetTimestampInMillisecond) {
            this.parquetTimestampInMillisecond = parquetTimestampInMillisecond;
            return this;
        }

        public final Boolean getCdcInsertsAndUpdates() {
            return this.cdcInsertsAndUpdates;
        }

        public final void setCdcInsertsAndUpdates(Boolean cdcInsertsAndUpdates) {
            this.cdcInsertsAndUpdates = cdcInsertsAndUpdates;
        }

        @Override
        @Transient
        public final Builder cdcInsertsAndUpdates(Boolean cdcInsertsAndUpdates) {
            this.cdcInsertsAndUpdates = cdcInsertsAndUpdates;
            return this;
        }

        public final Boolean getDatePartitionEnabled() {
            return this.datePartitionEnabled;
        }

        public final void setDatePartitionEnabled(Boolean datePartitionEnabled) {
            this.datePartitionEnabled = datePartitionEnabled;
        }

        @Override
        @Transient
        public final Builder datePartitionEnabled(Boolean datePartitionEnabled) {
            this.datePartitionEnabled = datePartitionEnabled;
            return this;
        }

        public final String getDatePartitionSequence() {
            return this.datePartitionSequence;
        }

        public final void setDatePartitionSequence(String datePartitionSequence) {
            this.datePartitionSequence = datePartitionSequence;
        }

        @Override
        @Transient
        public final Builder datePartitionSequence(String datePartitionSequence) {
            this.datePartitionSequence = datePartitionSequence;
            return this;
        }

        @Override
        @Transient
        public final Builder datePartitionSequence(DatePartitionSequenceValue datePartitionSequence) {
            this.datePartitionSequence(datePartitionSequence == null ? null : datePartitionSequence.toString());
            return this;
        }

        public final String getDatePartitionDelimiter() {
            return this.datePartitionDelimiter;
        }

        public final void setDatePartitionDelimiter(String datePartitionDelimiter) {
            this.datePartitionDelimiter = datePartitionDelimiter;
        }

        @Override
        @Transient
        public final Builder datePartitionDelimiter(String datePartitionDelimiter) {
            this.datePartitionDelimiter = datePartitionDelimiter;
            return this;
        }

        @Override
        @Transient
        public final Builder datePartitionDelimiter(DatePartitionDelimiterValue datePartitionDelimiter) {
            this.datePartitionDelimiter(datePartitionDelimiter == null ? null : datePartitionDelimiter.toString());
            return this;
        }

        public final Boolean getUseCsvNoSupValue() {
            return this.useCsvNoSupValue;
        }

        public final void setUseCsvNoSupValue(Boolean useCsvNoSupValue) {
            this.useCsvNoSupValue = useCsvNoSupValue;
        }

        @Override
        @Transient
        public final Builder useCsvNoSupValue(Boolean useCsvNoSupValue) {
            this.useCsvNoSupValue = useCsvNoSupValue;
            return this;
        }

        public final String getCsvNoSupValue() {
            return this.csvNoSupValue;
        }

        public final void setCsvNoSupValue(String csvNoSupValue) {
            this.csvNoSupValue = csvNoSupValue;
        }

        @Override
        @Transient
        public final Builder csvNoSupValue(String csvNoSupValue) {
            this.csvNoSupValue = csvNoSupValue;
            return this;
        }

        public final Boolean getPreserveTransactions() {
            return this.preserveTransactions;
        }

        public final void setPreserveTransactions(Boolean preserveTransactions) {
            this.preserveTransactions = preserveTransactions;
        }

        @Override
        @Transient
        public final Builder preserveTransactions(Boolean preserveTransactions) {
            this.preserveTransactions = preserveTransactions;
            return this;
        }

        public final String getCdcPath() {
            return this.cdcPath;
        }

        public final void setCdcPath(String cdcPath) {
            this.cdcPath = cdcPath;
        }

        @Override
        @Transient
        public final Builder cdcPath(String cdcPath) {
            this.cdcPath = cdcPath;
            return this;
        }

        public final Boolean getUseTaskStartTimeForFullLoadTimestamp() {
            return this.useTaskStartTimeForFullLoadTimestamp;
        }

        public final void setUseTaskStartTimeForFullLoadTimestamp(Boolean useTaskStartTimeForFullLoadTimestamp) {
            this.useTaskStartTimeForFullLoadTimestamp = useTaskStartTimeForFullLoadTimestamp;
        }

        @Override
        @Transient
        public final Builder useTaskStartTimeForFullLoadTimestamp(Boolean useTaskStartTimeForFullLoadTimestamp) {
            this.useTaskStartTimeForFullLoadTimestamp = useTaskStartTimeForFullLoadTimestamp;
            return this;
        }

        public final String getCannedAclForObjects() {
            return this.cannedAclForObjects;
        }

        public final void setCannedAclForObjects(String cannedAclForObjects) {
            this.cannedAclForObjects = cannedAclForObjects;
        }

        @Override
        @Transient
        public final Builder cannedAclForObjects(String cannedAclForObjects) {
            this.cannedAclForObjects = cannedAclForObjects;
            return this;
        }

        @Override
        @Transient
        public final Builder cannedAclForObjects(CannedAclForObjectsValue cannedAclForObjects) {
            this.cannedAclForObjects(cannedAclForObjects == null ? null : cannedAclForObjects.toString());
            return this;
        }

        public final Boolean getAddColumnName() {
            return this.addColumnName;
        }

        public final void setAddColumnName(Boolean addColumnName) {
            this.addColumnName = addColumnName;
        }

        @Override
        @Transient
        public final Builder addColumnName(Boolean addColumnName) {
            this.addColumnName = addColumnName;
            return this;
        }

        public final Integer getCdcMaxBatchInterval() {
            return this.cdcMaxBatchInterval;
        }

        public final void setCdcMaxBatchInterval(Integer cdcMaxBatchInterval) {
            this.cdcMaxBatchInterval = cdcMaxBatchInterval;
        }

        @Override
        @Transient
        public final Builder cdcMaxBatchInterval(Integer cdcMaxBatchInterval) {
            this.cdcMaxBatchInterval = cdcMaxBatchInterval;
            return this;
        }

        public final Integer getCdcMinFileSize() {
            return this.cdcMinFileSize;
        }

        public final void setCdcMinFileSize(Integer cdcMinFileSize) {
            this.cdcMinFileSize = cdcMinFileSize;
        }

        @Override
        @Transient
        public final Builder cdcMinFileSize(Integer cdcMinFileSize) {
            this.cdcMinFileSize = cdcMinFileSize;
            return this;
        }

        public final String getCsvNullValue() {
            return this.csvNullValue;
        }

        public final void setCsvNullValue(String csvNullValue) {
            this.csvNullValue = csvNullValue;
        }

        @Override
        @Transient
        public final Builder csvNullValue(String csvNullValue) {
            this.csvNullValue = csvNullValue;
            return this;
        }

        public final Integer getIgnoreHeaderRows() {
            return this.ignoreHeaderRows;
        }

        public final void setIgnoreHeaderRows(Integer ignoreHeaderRows) {
            this.ignoreHeaderRows = ignoreHeaderRows;
        }

        @Override
        @Transient
        public final Builder ignoreHeaderRows(Integer ignoreHeaderRows) {
            this.ignoreHeaderRows = ignoreHeaderRows;
            return this;
        }

        public final Integer getMaxFileSize() {
            return this.maxFileSize;
        }

        public final void setMaxFileSize(Integer maxFileSize) {
            this.maxFileSize = maxFileSize;
        }

        @Override
        @Transient
        public final Builder maxFileSize(Integer maxFileSize) {
            this.maxFileSize = maxFileSize;
            return this;
        }

        public final Boolean getRfc4180() {
            return this.rfc4180;
        }

        public final void setRfc4180(Boolean rfc4180) {
            this.rfc4180 = rfc4180;
        }

        @Override
        @Transient
        public final Builder rfc4180(Boolean rfc4180) {
            this.rfc4180 = rfc4180;
            return this;
        }

        public final String getDatePartitionTimezone() {
            return this.datePartitionTimezone;
        }

        public final void setDatePartitionTimezone(String datePartitionTimezone) {
            this.datePartitionTimezone = datePartitionTimezone;
        }

        @Override
        @Transient
        public final Builder datePartitionTimezone(String datePartitionTimezone) {
            this.datePartitionTimezone = datePartitionTimezone;
            return this;
        }

        public S3Settings build() {
            return new S3Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Settings> {
        public Builder serviceAccessRoleArn(String var1);

        public Builder externalTableDefinition(String var1);

        public Builder csvRowDelimiter(String var1);

        public Builder csvDelimiter(String var1);

        public Builder bucketFolder(String var1);

        public Builder bucketName(String var1);

        public Builder compressionType(String var1);

        public Builder compressionType(CompressionTypeValue var1);

        public Builder encryptionMode(String var1);

        public Builder encryptionMode(EncryptionModeValue var1);

        public Builder serverSideEncryptionKmsKeyId(String var1);

        public Builder dataFormat(String var1);

        public Builder dataFormat(DataFormatValue var1);

        public Builder encodingType(String var1);

        public Builder encodingType(EncodingTypeValue var1);

        public Builder dictPageSizeLimit(Integer var1);

        public Builder rowGroupLength(Integer var1);

        public Builder dataPageSize(Integer var1);

        public Builder parquetVersion(String var1);

        public Builder parquetVersion(ParquetVersionValue var1);

        public Builder enableStatistics(Boolean var1);

        public Builder includeOpForFullLoad(Boolean var1);

        public Builder cdcInsertsOnly(Boolean var1);

        public Builder timestampColumnName(String var1);

        public Builder parquetTimestampInMillisecond(Boolean var1);

        public Builder cdcInsertsAndUpdates(Boolean var1);

        public Builder datePartitionEnabled(Boolean var1);

        public Builder datePartitionSequence(String var1);

        public Builder datePartitionSequence(DatePartitionSequenceValue var1);

        public Builder datePartitionDelimiter(String var1);

        public Builder datePartitionDelimiter(DatePartitionDelimiterValue var1);

        public Builder useCsvNoSupValue(Boolean var1);

        public Builder csvNoSupValue(String var1);

        public Builder preserveTransactions(Boolean var1);

        public Builder cdcPath(String var1);

        public Builder useTaskStartTimeForFullLoadTimestamp(Boolean var1);

        public Builder cannedAclForObjects(String var1);

        public Builder cannedAclForObjects(CannedAclForObjectsValue var1);

        public Builder addColumnName(Boolean var1);

        public Builder cdcMaxBatchInterval(Integer var1);

        public Builder cdcMinFileSize(Integer var1);

        public Builder csvNullValue(String var1);

        public Builder ignoreHeaderRows(Integer var1);

        public Builder maxFileSize(Integer var1);

        public Builder rfc4180(Boolean var1);

        public Builder datePartitionTimezone(String var1);
    }
}

