/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EndpointSettingTypeValue {
    STRING("string"),
    BOOLEAN("boolean"),
    INTEGER("integer"),
    ENUM("enum"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EndpointSettingTypeValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EndpointSettingTypeValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EndpointSettingTypeValue.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EndpointSettingTypeValue> knownValues() {
        return Stream.of(EndpointSettingTypeValue.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

