/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRun;
import software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRunListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReplicationTaskAssessmentRunsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeReplicationTaskAssessmentRunsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeReplicationTaskAssessmentRunsResponse.getter(DescribeReplicationTaskAssessmentRunsResponse::marker)).setter(DescribeReplicationTaskAssessmentRunsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ReplicationTaskAssessmentRun>> REPLICATION_TASK_ASSESSMENT_RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationTaskAssessmentRuns").getter(DescribeReplicationTaskAssessmentRunsResponse.getter(DescribeReplicationTaskAssessmentRunsResponse::replicationTaskAssessmentRuns)).setter(DescribeReplicationTaskAssessmentRunsResponse.setter(Builder::replicationTaskAssessmentRuns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskAssessmentRuns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationTaskAssessmentRun::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, REPLICATION_TASK_ASSESSMENT_RUNS_FIELD));
    private final String marker;
    private final List<ReplicationTaskAssessmentRun> replicationTaskAssessmentRuns;

    private DescribeReplicationTaskAssessmentRunsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.replicationTaskAssessmentRuns = builder.replicationTaskAssessmentRuns;
    }

    public String marker() {
        return this.marker;
    }

    public boolean hasReplicationTaskAssessmentRuns() {
        return this.replicationTaskAssessmentRuns != null && !(this.replicationTaskAssessmentRuns instanceof SdkAutoConstructList);
    }

    public List<ReplicationTaskAssessmentRun> replicationTaskAssessmentRuns() {
        return this.replicationTaskAssessmentRuns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationTaskAssessmentRuns() ? this.replicationTaskAssessmentRuns() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationTaskAssessmentRunsResponse)) {
            return false;
        }
        DescribeReplicationTaskAssessmentRunsResponse other = (DescribeReplicationTaskAssessmentRunsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasReplicationTaskAssessmentRuns() == other.hasReplicationTaskAssessmentRuns() && Objects.equals(this.replicationTaskAssessmentRuns(), other.replicationTaskAssessmentRuns());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReplicationTaskAssessmentRunsResponse").add("Marker", (Object)this.marker()).add("ReplicationTaskAssessmentRuns", this.hasReplicationTaskAssessmentRuns() ? this.replicationTaskAssessmentRuns() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ReplicationTaskAssessmentRuns": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskAssessmentRuns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationTaskAssessmentRunsResponse, T> g) {
        return obj -> g.apply((DescribeReplicationTaskAssessmentRunsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReplicationTaskAssessmentRun> replicationTaskAssessmentRuns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationTaskAssessmentRunsResponse model) {
            super(model);
            this.marker(model.marker);
            this.replicationTaskAssessmentRuns(model.replicationTaskAssessmentRuns);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReplicationTaskAssessmentRun.Builder> getReplicationTaskAssessmentRuns() {
            if (this.replicationTaskAssessmentRuns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationTaskAssessmentRuns != null ? (Collection)this.replicationTaskAssessmentRuns.stream().map(ReplicationTaskAssessmentRun::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationTaskAssessmentRuns(Collection<ReplicationTaskAssessmentRun> replicationTaskAssessmentRuns) {
            this.replicationTaskAssessmentRuns = ReplicationTaskAssessmentRunListCopier.copy(replicationTaskAssessmentRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTaskAssessmentRuns(ReplicationTaskAssessmentRun ... replicationTaskAssessmentRuns) {
            this.replicationTaskAssessmentRuns(Arrays.asList(replicationTaskAssessmentRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTaskAssessmentRuns(Consumer<ReplicationTaskAssessmentRun.Builder> ... replicationTaskAssessmentRuns) {
            this.replicationTaskAssessmentRuns(Stream.of(replicationTaskAssessmentRuns).map(c -> (ReplicationTaskAssessmentRun)((ReplicationTaskAssessmentRun.Builder)ReplicationTaskAssessmentRun.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationTaskAssessmentRuns(Collection<ReplicationTaskAssessmentRun.BuilderImpl> replicationTaskAssessmentRuns) {
            this.replicationTaskAssessmentRuns = ReplicationTaskAssessmentRunListCopier.copyFromBuilder(replicationTaskAssessmentRuns);
        }

        @Override
        public DescribeReplicationTaskAssessmentRunsResponse build() {
            return new DescribeReplicationTaskAssessmentRunsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReplicationTaskAssessmentRunsResponse> {
        public Builder marker(String var1);

        public Builder replicationTaskAssessmentRuns(Collection<ReplicationTaskAssessmentRun> var1);

        public Builder replicationTaskAssessmentRuns(ReplicationTaskAssessmentRun ... var1);

        public Builder replicationTaskAssessmentRuns(Consumer<ReplicationTaskAssessmentRun.Builder> ... var1);
    }
}

