/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OracleSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OracleSettings> {
    private static final SdkField<String> ASM_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AsmPassword").getter(OracleSettings.getter(OracleSettings::asmPassword)).setter(OracleSettings.setter(Builder::asmPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsmPassword").build()}).build();
    private static final SdkField<String> ASM_SERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AsmServer").getter(OracleSettings.getter(OracleSettings::asmServer)).setter(OracleSettings.setter(Builder::asmServer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsmServer").build()}).build();
    private static final SdkField<String> ASM_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AsmUser").getter(OracleSettings.getter(OracleSettings::asmUser)).setter(OracleSettings.setter(Builder::asmUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsmUser").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(OracleSettings.getter(OracleSettings::databaseName)).setter(OracleSettings.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(OracleSettings.getter(OracleSettings::password)).setter(OracleSettings.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(OracleSettings.getter(OracleSettings::port)).setter(OracleSettings.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> SECURITY_DB_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityDbEncryption").getter(OracleSettings.getter(OracleSettings::securityDbEncryption)).setter(OracleSettings.setter(Builder::securityDbEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityDbEncryption").build()}).build();
    private static final SdkField<String> SECURITY_DB_ENCRYPTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityDbEncryptionName").getter(OracleSettings.getter(OracleSettings::securityDbEncryptionName)).setter(OracleSettings.setter(Builder::securityDbEncryptionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityDbEncryptionName").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(OracleSettings.getter(OracleSettings::serverName)).setter(OracleSettings.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(OracleSettings.getter(OracleSettings::username)).setter(OracleSettings.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASM_PASSWORD_FIELD, ASM_SERVER_FIELD, ASM_USER_FIELD, DATABASE_NAME_FIELD, PASSWORD_FIELD, PORT_FIELD, SECURITY_DB_ENCRYPTION_FIELD, SECURITY_DB_ENCRYPTION_NAME_FIELD, SERVER_NAME_FIELD, USERNAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String asmPassword;
    private final String asmServer;
    private final String asmUser;
    private final String databaseName;
    private final String password;
    private final Integer port;
    private final String securityDbEncryption;
    private final String securityDbEncryptionName;
    private final String serverName;
    private final String username;

    private OracleSettings(BuilderImpl builder) {
        this.asmPassword = builder.asmPassword;
        this.asmServer = builder.asmServer;
        this.asmUser = builder.asmUser;
        this.databaseName = builder.databaseName;
        this.password = builder.password;
        this.port = builder.port;
        this.securityDbEncryption = builder.securityDbEncryption;
        this.securityDbEncryptionName = builder.securityDbEncryptionName;
        this.serverName = builder.serverName;
        this.username = builder.username;
    }

    public String asmPassword() {
        return this.asmPassword;
    }

    public String asmServer() {
        return this.asmServer;
    }

    public String asmUser() {
        return this.asmUser;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String password() {
        return this.password;
    }

    public Integer port() {
        return this.port;
    }

    public String securityDbEncryption() {
        return this.securityDbEncryption;
    }

    public String securityDbEncryptionName() {
        return this.securityDbEncryptionName;
    }

    public String serverName() {
        return this.serverName;
    }

    public String username() {
        return this.username;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.asmPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.asmServer());
        hashCode = 31 * hashCode + Objects.hashCode(this.asmUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityDbEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityDbEncryptionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OracleSettings)) {
            return false;
        }
        OracleSettings other = (OracleSettings)obj;
        return Objects.equals(this.asmPassword(), other.asmPassword()) && Objects.equals(this.asmServer(), other.asmServer()) && Objects.equals(this.asmUser(), other.asmUser()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.securityDbEncryption(), other.securityDbEncryption()) && Objects.equals(this.securityDbEncryptionName(), other.securityDbEncryptionName()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.username(), other.username());
    }

    public String toString() {
        return ToString.builder((String)"OracleSettings").add("AsmPassword", (Object)(this.asmPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("AsmServer", (Object)this.asmServer()).add("AsmUser", (Object)this.asmUser()).add("DatabaseName", (Object)this.databaseName()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("Port", (Object)this.port()).add("SecurityDbEncryption", (Object)(this.securityDbEncryption() == null ? null : "*** Sensitive Data Redacted ***")).add("SecurityDbEncryptionName", (Object)this.securityDbEncryptionName()).add("ServerName", (Object)this.serverName()).add("Username", (Object)this.username()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AsmPassword": {
                return Optional.ofNullable(clazz.cast(this.asmPassword()));
            }
            case "AsmServer": {
                return Optional.ofNullable(clazz.cast(this.asmServer()));
            }
            case "AsmUser": {
                return Optional.ofNullable(clazz.cast(this.asmUser()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "SecurityDbEncryption": {
                return Optional.ofNullable(clazz.cast(this.securityDbEncryption()));
            }
            case "SecurityDbEncryptionName": {
                return Optional.ofNullable(clazz.cast(this.securityDbEncryptionName()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OracleSettings, T> g) {
        return obj -> g.apply((OracleSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String asmPassword;
        private String asmServer;
        private String asmUser;
        private String databaseName;
        private String password;
        private Integer port;
        private String securityDbEncryption;
        private String securityDbEncryptionName;
        private String serverName;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(OracleSettings model) {
            this.asmPassword(model.asmPassword);
            this.asmServer(model.asmServer);
            this.asmUser(model.asmUser);
            this.databaseName(model.databaseName);
            this.password(model.password);
            this.port(model.port);
            this.securityDbEncryption(model.securityDbEncryption);
            this.securityDbEncryptionName(model.securityDbEncryptionName);
            this.serverName(model.serverName);
            this.username(model.username);
        }

        public final String getAsmPassword() {
            return this.asmPassword;
        }

        @Override
        public final Builder asmPassword(String asmPassword) {
            this.asmPassword = asmPassword;
            return this;
        }

        public final void setAsmPassword(String asmPassword) {
            this.asmPassword = asmPassword;
        }

        public final String getAsmServer() {
            return this.asmServer;
        }

        @Override
        public final Builder asmServer(String asmServer) {
            this.asmServer = asmServer;
            return this;
        }

        public final void setAsmServer(String asmServer) {
            this.asmServer = asmServer;
        }

        public final String getAsmUser() {
            return this.asmUser;
        }

        @Override
        public final Builder asmUser(String asmUser) {
            this.asmUser = asmUser;
            return this;
        }

        public final void setAsmUser(String asmUser) {
            this.asmUser = asmUser;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getSecurityDbEncryption() {
            return this.securityDbEncryption;
        }

        @Override
        public final Builder securityDbEncryption(String securityDbEncryption) {
            this.securityDbEncryption = securityDbEncryption;
            return this;
        }

        public final void setSecurityDbEncryption(String securityDbEncryption) {
            this.securityDbEncryption = securityDbEncryption;
        }

        public final String getSecurityDbEncryptionName() {
            return this.securityDbEncryptionName;
        }

        @Override
        public final Builder securityDbEncryptionName(String securityDbEncryptionName) {
            this.securityDbEncryptionName = securityDbEncryptionName;
            return this;
        }

        public final void setSecurityDbEncryptionName(String securityDbEncryptionName) {
            this.securityDbEncryptionName = securityDbEncryptionName;
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public OracleSettings build() {
            return new OracleSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OracleSettings> {
        public Builder asmPassword(String var1);

        public Builder asmServer(String var1);

        public Builder asmUser(String var1);

        public Builder databaseName(String var1);

        public Builder password(String var1);

        public Builder port(Integer var1);

        public Builder securityDbEncryption(String var1);

        public Builder securityDbEncryptionName(String var1);

        public Builder serverName(String var1);

        public Builder username(String var1);
    }
}

