/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.AccountQuota;
import software.amazon.awssdk.services.databasemigration.model.AccountQuotaListCopier;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccountAttributesResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeAccountAttributesResponse> {
    private static final SdkField<List<AccountQuota>> ACCOUNT_QUOTAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountQuotas").getter(DescribeAccountAttributesResponse.getter(DescribeAccountAttributesResponse::accountQuotas)).setter(DescribeAccountAttributesResponse.setter(Builder::accountQuotas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountQuotas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountQuota::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UNIQUE_ACCOUNT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UniqueAccountIdentifier").getter(DescribeAccountAttributesResponse.getter(DescribeAccountAttributesResponse::uniqueAccountIdentifier)).setter(DescribeAccountAttributesResponse.setter(Builder::uniqueAccountIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueAccountIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_QUOTAS_FIELD, UNIQUE_ACCOUNT_IDENTIFIER_FIELD));
    private final List<AccountQuota> accountQuotas;
    private final String uniqueAccountIdentifier;

    private DescribeAccountAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.accountQuotas = builder.accountQuotas;
        this.uniqueAccountIdentifier = builder.uniqueAccountIdentifier;
    }

    public boolean hasAccountQuotas() {
        return this.accountQuotas != null && !(this.accountQuotas instanceof SdkAutoConstructList);
    }

    public List<AccountQuota> accountQuotas() {
        return this.accountQuotas;
    }

    public String uniqueAccountIdentifier() {
        return this.uniqueAccountIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountQuotas());
        hashCode = 31 * hashCode + Objects.hashCode(this.uniqueAccountIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAttributesResponse)) {
            return false;
        }
        DescribeAccountAttributesResponse other = (DescribeAccountAttributesResponse)((Object)obj);
        return Objects.equals(this.accountQuotas(), other.accountQuotas()) && Objects.equals(this.uniqueAccountIdentifier(), other.uniqueAccountIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAccountAttributesResponse").add("AccountQuotas", this.accountQuotas()).add("UniqueAccountIdentifier", (Object)this.uniqueAccountIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountQuotas": {
                return Optional.ofNullable(clazz.cast(this.accountQuotas()));
            }
            case "UniqueAccountIdentifier": {
                return Optional.ofNullable(clazz.cast(this.uniqueAccountIdentifier()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountAttributesResponse, T> g) {
        return obj -> g.apply((DescribeAccountAttributesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private List<AccountQuota> accountQuotas = DefaultSdkAutoConstructList.getInstance();
        private String uniqueAccountIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAttributesResponse model) {
            super(model);
            this.accountQuotas(model.accountQuotas);
            this.uniqueAccountIdentifier(model.uniqueAccountIdentifier);
        }

        public final Collection<AccountQuota.Builder> getAccountQuotas() {
            return this.accountQuotas != null ? (Collection)this.accountQuotas.stream().map(AccountQuota::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountQuotas(Collection<AccountQuota> accountQuotas) {
            this.accountQuotas = AccountQuotaListCopier.copy(accountQuotas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountQuotas(AccountQuota ... accountQuotas) {
            this.accountQuotas(Arrays.asList(accountQuotas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountQuotas(Consumer<AccountQuota.Builder> ... accountQuotas) {
            this.accountQuotas(Stream.of(accountQuotas).map(c -> (AccountQuota)((AccountQuota.Builder)AccountQuota.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccountQuotas(Collection<AccountQuota.BuilderImpl> accountQuotas) {
            this.accountQuotas = AccountQuotaListCopier.copyFromBuilder(accountQuotas);
        }

        public final String getUniqueAccountIdentifier() {
            return this.uniqueAccountIdentifier;
        }

        @Override
        public final Builder uniqueAccountIdentifier(String uniqueAccountIdentifier) {
            this.uniqueAccountIdentifier = uniqueAccountIdentifier;
            return this;
        }

        public final void setUniqueAccountIdentifier(String uniqueAccountIdentifier) {
            this.uniqueAccountIdentifier = uniqueAccountIdentifier;
        }

        @Override
        public DescribeAccountAttributesResponse build() {
            return new DescribeAccountAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccountAttributesResponse> {
        public Builder accountQuotas(Collection<AccountQuota> var1);

        public Builder accountQuotas(AccountQuota ... var1);

        public Builder accountQuotas(Consumer<AccountQuota.Builder> ... var1);

        public Builder uniqueAccountIdentifier(String var1);
    }
}

