/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentResult;
import software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentResultListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReplicationTaskAssessmentResultsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeReplicationTaskAssessmentResultsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeReplicationTaskAssessmentResultsResponse.getter(DescribeReplicationTaskAssessmentResultsResponse::marker)).setter(DescribeReplicationTaskAssessmentResultsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketName").getter(DescribeReplicationTaskAssessmentResultsResponse.getter(DescribeReplicationTaskAssessmentResultsResponse::bucketName)).setter(DescribeReplicationTaskAssessmentResultsResponse.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()}).build();
    private static final SdkField<List<ReplicationTaskAssessmentResult>> REPLICATION_TASK_ASSESSMENT_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationTaskAssessmentResults").getter(DescribeReplicationTaskAssessmentResultsResponse.getter(DescribeReplicationTaskAssessmentResultsResponse::replicationTaskAssessmentResults)).setter(DescribeReplicationTaskAssessmentResultsResponse.setter(Builder::replicationTaskAssessmentResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskAssessmentResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationTaskAssessmentResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, BUCKET_NAME_FIELD, REPLICATION_TASK_ASSESSMENT_RESULTS_FIELD));
    private final String marker;
    private final String bucketName;
    private final List<ReplicationTaskAssessmentResult> replicationTaskAssessmentResults;

    private DescribeReplicationTaskAssessmentResultsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.bucketName = builder.bucketName;
        this.replicationTaskAssessmentResults = builder.replicationTaskAssessmentResults;
    }

    public String marker() {
        return this.marker;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public boolean hasReplicationTaskAssessmentResults() {
        return this.replicationTaskAssessmentResults != null && !(this.replicationTaskAssessmentResults instanceof SdkAutoConstructList);
    }

    public List<ReplicationTaskAssessmentResult> replicationTaskAssessmentResults() {
        return this.replicationTaskAssessmentResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationTaskAssessmentResults() ? this.replicationTaskAssessmentResults() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationTaskAssessmentResultsResponse)) {
            return false;
        }
        DescribeReplicationTaskAssessmentResultsResponse other = (DescribeReplicationTaskAssessmentResultsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.bucketName(), other.bucketName()) && this.hasReplicationTaskAssessmentResults() == other.hasReplicationTaskAssessmentResults() && Objects.equals(this.replicationTaskAssessmentResults(), other.replicationTaskAssessmentResults());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReplicationTaskAssessmentResultsResponse").add("Marker", (Object)this.marker()).add("BucketName", (Object)this.bucketName()).add("ReplicationTaskAssessmentResults", this.hasReplicationTaskAssessmentResults() ? this.replicationTaskAssessmentResults() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "ReplicationTaskAssessmentResults": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskAssessmentResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationTaskAssessmentResultsResponse, T> g) {
        return obj -> g.apply((DescribeReplicationTaskAssessmentResultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String marker;
        private String bucketName;
        private List<ReplicationTaskAssessmentResult> replicationTaskAssessmentResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationTaskAssessmentResultsResponse model) {
            super(model);
            this.marker(model.marker);
            this.bucketName(model.bucketName);
            this.replicationTaskAssessmentResults(model.replicationTaskAssessmentResults);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final Collection<ReplicationTaskAssessmentResult.Builder> getReplicationTaskAssessmentResults() {
            if (this.replicationTaskAssessmentResults instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationTaskAssessmentResults != null ? (Collection)this.replicationTaskAssessmentResults.stream().map(ReplicationTaskAssessmentResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationTaskAssessmentResults(Collection<ReplicationTaskAssessmentResult> replicationTaskAssessmentResults) {
            this.replicationTaskAssessmentResults = ReplicationTaskAssessmentResultListCopier.copy(replicationTaskAssessmentResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTaskAssessmentResults(ReplicationTaskAssessmentResult ... replicationTaskAssessmentResults) {
            this.replicationTaskAssessmentResults(Arrays.asList(replicationTaskAssessmentResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTaskAssessmentResults(Consumer<ReplicationTaskAssessmentResult.Builder> ... replicationTaskAssessmentResults) {
            this.replicationTaskAssessmentResults(Stream.of(replicationTaskAssessmentResults).map(c -> (ReplicationTaskAssessmentResult)((ReplicationTaskAssessmentResult.Builder)ReplicationTaskAssessmentResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationTaskAssessmentResults(Collection<ReplicationTaskAssessmentResult.BuilderImpl> replicationTaskAssessmentResults) {
            this.replicationTaskAssessmentResults = ReplicationTaskAssessmentResultListCopier.copyFromBuilder(replicationTaskAssessmentResults);
        }

        @Override
        public DescribeReplicationTaskAssessmentResultsResponse build() {
            return new DescribeReplicationTaskAssessmentResultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReplicationTaskAssessmentResultsResponse> {
        public Builder marker(String var1);

        public Builder bucketName(String var1);

        public Builder replicationTaskAssessmentResults(Collection<ReplicationTaskAssessmentResult> var1);

        public Builder replicationTaskAssessmentResults(ReplicationTaskAssessmentResult ... var1);

        public Builder replicationTaskAssessmentResults(Consumer<ReplicationTaskAssessmentResult.Builder> ... var1);
    }
}

