/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.MessageFormatValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisSettings> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KinesisSettings.getter(KinesisSettings::streamArn)).setter(KinesisSettings.setter(Builder::streamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()}).build();
    private static final SdkField<String> MESSAGE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KinesisSettings.getter(KinesisSettings::messageFormatAsString)).setter(KinesisSettings.setter(Builder::messageFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageFormat").build()}).build();
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KinesisSettings.getter(KinesisSettings::serviceAccessRoleArn)).setter(KinesisSettings.setter(Builder::serviceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build()}).build();
    private static final SdkField<Boolean> INCLUDE_TRANSACTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(KinesisSettings.getter(KinesisSettings::includeTransactionDetails)).setter(KinesisSettings.setter(Builder::includeTransactionDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTransactionDetails").build()}).build();
    private static final SdkField<Boolean> INCLUDE_PARTITION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(KinesisSettings.getter(KinesisSettings::includePartitionValue)).setter(KinesisSettings.setter(Builder::includePartitionValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludePartitionValue").build()}).build();
    private static final SdkField<Boolean> PARTITION_INCLUDE_SCHEMA_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(KinesisSettings.getter(KinesisSettings::partitionIncludeSchemaTable)).setter(KinesisSettings.setter(Builder::partitionIncludeSchemaTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionIncludeSchemaTable").build()}).build();
    private static final SdkField<Boolean> INCLUDE_TABLE_ALTER_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(KinesisSettings.getter(KinesisSettings::includeTableAlterOperations)).setter(KinesisSettings.setter(Builder::includeTableAlterOperations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTableAlterOperations").build()}).build();
    private static final SdkField<Boolean> INCLUDE_CONTROL_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(KinesisSettings.getter(KinesisSettings::includeControlDetails)).setter(KinesisSettings.setter(Builder::includeControlDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeControlDetails").build()}).build();
    private static final SdkField<Boolean> INCLUDE_NULL_AND_EMPTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(KinesisSettings.getter(KinesisSettings::includeNullAndEmpty)).setter(KinesisSettings.setter(Builder::includeNullAndEmpty)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeNullAndEmpty").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD, MESSAGE_FORMAT_FIELD, SERVICE_ACCESS_ROLE_ARN_FIELD, INCLUDE_TRANSACTION_DETAILS_FIELD, INCLUDE_PARTITION_VALUE_FIELD, PARTITION_INCLUDE_SCHEMA_TABLE_FIELD, INCLUDE_TABLE_ALTER_OPERATIONS_FIELD, INCLUDE_CONTROL_DETAILS_FIELD, INCLUDE_NULL_AND_EMPTY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String streamArn;
    private final String messageFormat;
    private final String serviceAccessRoleArn;
    private final Boolean includeTransactionDetails;
    private final Boolean includePartitionValue;
    private final Boolean partitionIncludeSchemaTable;
    private final Boolean includeTableAlterOperations;
    private final Boolean includeControlDetails;
    private final Boolean includeNullAndEmpty;

    private KinesisSettings(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.messageFormat = builder.messageFormat;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.includeTransactionDetails = builder.includeTransactionDetails;
        this.includePartitionValue = builder.includePartitionValue;
        this.partitionIncludeSchemaTable = builder.partitionIncludeSchemaTable;
        this.includeTableAlterOperations = builder.includeTableAlterOperations;
        this.includeControlDetails = builder.includeControlDetails;
        this.includeNullAndEmpty = builder.includeNullAndEmpty;
    }

    public String streamArn() {
        return this.streamArn;
    }

    public MessageFormatValue messageFormat() {
        return MessageFormatValue.fromValue(this.messageFormat);
    }

    public String messageFormatAsString() {
        return this.messageFormat;
    }

    public String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public Boolean includeTransactionDetails() {
        return this.includeTransactionDetails;
    }

    public Boolean includePartitionValue() {
        return this.includePartitionValue;
    }

    public Boolean partitionIncludeSchemaTable() {
        return this.partitionIncludeSchemaTable;
    }

    public Boolean includeTableAlterOperations() {
        return this.includeTableAlterOperations;
    }

    public Boolean includeControlDetails() {
        return this.includeControlDetails;
    }

    public Boolean includeNullAndEmpty() {
        return this.includeNullAndEmpty;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeTransactionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.includePartitionValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionIncludeSchemaTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeTableAlterOperations());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeControlDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeNullAndEmpty());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisSettings)) {
            return false;
        }
        KinesisSettings other = (KinesisSettings)obj;
        return Objects.equals(this.streamArn(), other.streamArn()) && Objects.equals(this.messageFormatAsString(), other.messageFormatAsString()) && Objects.equals(this.serviceAccessRoleArn(), other.serviceAccessRoleArn()) && Objects.equals(this.includeTransactionDetails(), other.includeTransactionDetails()) && Objects.equals(this.includePartitionValue(), other.includePartitionValue()) && Objects.equals(this.partitionIncludeSchemaTable(), other.partitionIncludeSchemaTable()) && Objects.equals(this.includeTableAlterOperations(), other.includeTableAlterOperations()) && Objects.equals(this.includeControlDetails(), other.includeControlDetails()) && Objects.equals(this.includeNullAndEmpty(), other.includeNullAndEmpty());
    }

    public String toString() {
        return ToString.builder((String)"KinesisSettings").add("StreamArn", (Object)this.streamArn()).add("MessageFormat", (Object)this.messageFormatAsString()).add("ServiceAccessRoleArn", (Object)this.serviceAccessRoleArn()).add("IncludeTransactionDetails", (Object)this.includeTransactionDetails()).add("IncludePartitionValue", (Object)this.includePartitionValue()).add("PartitionIncludeSchemaTable", (Object)this.partitionIncludeSchemaTable()).add("IncludeTableAlterOperations", (Object)this.includeTableAlterOperations()).add("IncludeControlDetails", (Object)this.includeControlDetails()).add("IncludeNullAndEmpty", (Object)this.includeNullAndEmpty()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamArn": {
                return Optional.ofNullable(clazz.cast(this.streamArn()));
            }
            case "MessageFormat": {
                return Optional.ofNullable(clazz.cast(this.messageFormatAsString()));
            }
            case "ServiceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessRoleArn()));
            }
            case "IncludeTransactionDetails": {
                return Optional.ofNullable(clazz.cast(this.includeTransactionDetails()));
            }
            case "IncludePartitionValue": {
                return Optional.ofNullable(clazz.cast(this.includePartitionValue()));
            }
            case "PartitionIncludeSchemaTable": {
                return Optional.ofNullable(clazz.cast(this.partitionIncludeSchemaTable()));
            }
            case "IncludeTableAlterOperations": {
                return Optional.ofNullable(clazz.cast(this.includeTableAlterOperations()));
            }
            case "IncludeControlDetails": {
                return Optional.ofNullable(clazz.cast(this.includeControlDetails()));
            }
            case "IncludeNullAndEmpty": {
                return Optional.ofNullable(clazz.cast(this.includeNullAndEmpty()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisSettings, T> g) {
        return obj -> g.apply((KinesisSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamArn;
        private String messageFormat;
        private String serviceAccessRoleArn;
        private Boolean includeTransactionDetails;
        private Boolean includePartitionValue;
        private Boolean partitionIncludeSchemaTable;
        private Boolean includeTableAlterOperations;
        private Boolean includeControlDetails;
        private Boolean includeNullAndEmpty;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisSettings model) {
            this.streamArn(model.streamArn);
            this.messageFormat(model.messageFormat);
            this.serviceAccessRoleArn(model.serviceAccessRoleArn);
            this.includeTransactionDetails(model.includeTransactionDetails);
            this.includePartitionValue(model.includePartitionValue);
            this.partitionIncludeSchemaTable(model.partitionIncludeSchemaTable);
            this.includeTableAlterOperations(model.includeTableAlterOperations);
            this.includeControlDetails(model.includeControlDetails);
            this.includeNullAndEmpty(model.includeNullAndEmpty);
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final String getMessageFormat() {
            return this.messageFormat;
        }

        @Override
        public final Builder messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        @Override
        public final Builder messageFormat(MessageFormatValue messageFormat) {
            this.messageFormat(messageFormat == null ? null : messageFormat.toString());
            return this;
        }

        public final void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        public final String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        public final Boolean getIncludeTransactionDetails() {
            return this.includeTransactionDetails;
        }

        @Override
        public final Builder includeTransactionDetails(Boolean includeTransactionDetails) {
            this.includeTransactionDetails = includeTransactionDetails;
            return this;
        }

        public final void setIncludeTransactionDetails(Boolean includeTransactionDetails) {
            this.includeTransactionDetails = includeTransactionDetails;
        }

        public final Boolean getIncludePartitionValue() {
            return this.includePartitionValue;
        }

        @Override
        public final Builder includePartitionValue(Boolean includePartitionValue) {
            this.includePartitionValue = includePartitionValue;
            return this;
        }

        public final void setIncludePartitionValue(Boolean includePartitionValue) {
            this.includePartitionValue = includePartitionValue;
        }

        public final Boolean getPartitionIncludeSchemaTable() {
            return this.partitionIncludeSchemaTable;
        }

        @Override
        public final Builder partitionIncludeSchemaTable(Boolean partitionIncludeSchemaTable) {
            this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
            return this;
        }

        public final void setPartitionIncludeSchemaTable(Boolean partitionIncludeSchemaTable) {
            this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
        }

        public final Boolean getIncludeTableAlterOperations() {
            return this.includeTableAlterOperations;
        }

        @Override
        public final Builder includeTableAlterOperations(Boolean includeTableAlterOperations) {
            this.includeTableAlterOperations = includeTableAlterOperations;
            return this;
        }

        public final void setIncludeTableAlterOperations(Boolean includeTableAlterOperations) {
            this.includeTableAlterOperations = includeTableAlterOperations;
        }

        public final Boolean getIncludeControlDetails() {
            return this.includeControlDetails;
        }

        @Override
        public final Builder includeControlDetails(Boolean includeControlDetails) {
            this.includeControlDetails = includeControlDetails;
            return this;
        }

        public final void setIncludeControlDetails(Boolean includeControlDetails) {
            this.includeControlDetails = includeControlDetails;
        }

        public final Boolean getIncludeNullAndEmpty() {
            return this.includeNullAndEmpty;
        }

        @Override
        public final Builder includeNullAndEmpty(Boolean includeNullAndEmpty) {
            this.includeNullAndEmpty = includeNullAndEmpty;
            return this;
        }

        public final void setIncludeNullAndEmpty(Boolean includeNullAndEmpty) {
            this.includeNullAndEmpty = includeNullAndEmpty;
        }

        public KinesisSettings build() {
            return new KinesisSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisSettings> {
        public Builder streamArn(String var1);

        public Builder messageFormat(String var1);

        public Builder messageFormat(MessageFormatValue var1);

        public Builder serviceAccessRoleArn(String var1);

        public Builder includeTransactionDetails(Boolean var1);

        public Builder includePartitionValue(Boolean var1);

        public Builder partitionIncludeSchemaTable(Boolean var1);

        public Builder includeTableAlterOperations(Boolean var1);

        public Builder includeControlDetails(Boolean var1);

        public Builder includeNullAndEmpty(Boolean var1);
    }
}

