/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse;

public class DescribeOrderableReplicationInstancesPublisher
implements SdkPublisher<DescribeOrderableReplicationInstancesResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeOrderableReplicationInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeOrderableReplicationInstancesPublisher(DatabaseMigrationAsyncClient client, DescribeOrderableReplicationInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeOrderableReplicationInstancesPublisher(DatabaseMigrationAsyncClient client, DescribeOrderableReplicationInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeOrderableReplicationInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeOrderableReplicationInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final DescribeOrderableReplicationInstancesPublisher resume(DescribeOrderableReplicationInstancesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeOrderableReplicationInstancesPublisher(this.client, (DescribeOrderableReplicationInstancesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeOrderableReplicationInstancesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeOrderableReplicationInstancesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeOrderableReplicationInstancesResponseFetcher
    implements AsyncPageFetcher<DescribeOrderableReplicationInstancesResponse> {
        private DescribeOrderableReplicationInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrderableReplicationInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeOrderableReplicationInstancesResponse> nextPage(DescribeOrderableReplicationInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrderableReplicationInstancesPublisher.this.client.describeOrderableReplicationInstances(DescribeOrderableReplicationInstancesPublisher.this.firstRequest);
            }
            return DescribeOrderableReplicationInstancesPublisher.this.client.describeOrderableReplicationInstances((DescribeOrderableReplicationInstancesRequest)((Object)DescribeOrderableReplicationInstancesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

