/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue;
import software.amazon.awssdk.services.databasemigration.model.DmsTransferSettings;
import software.amazon.awssdk.services.databasemigration.model.DynamoDbSettings;
import software.amazon.awssdk.services.databasemigration.model.MongoDbSettings;
import software.amazon.awssdk.services.databasemigration.model.ReplicationEndpointTypeValue;
import software.amazon.awssdk.services.databasemigration.model.S3Settings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyEndpointRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, ModifyEndpointRequest> {
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyEndpointRequest.getter(ModifyEndpointRequest::endpointArn)).setter(ModifyEndpointRequest.setter(Builder::endpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()}).build();
    private static final SdkField<String> ENDPOINT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyEndpointRequest.getter(ModifyEndpointRequest::endpointIdentifier)).setter(ModifyEndpointRequest.setter(Builder::endpointIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIdentifier").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyEndpointRequest.getter(ModifyEndpointRequest::endpointTypeAsString)).setter(ModifyEndpointRequest.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<String> ENGINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyEndpointRequest.getter(ModifyEndpointRequest::engineName)).setter(ModifyEndpointRequest.setter(Builder::engineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineName").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyEndpointRequest.getter(ModifyEndpointRequest::username)).setter(ModifyEndpointRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyEndpointRequest.getter(ModifyEndpointRequest::password)).setter(ModifyEndpointRequest.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyEndpointRequest.getter(ModifyEndpointRequest::serverName)).setter(ModifyEndpointRequest.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ModifyEndpointRequest.getter(ModifyEndpointRequest::port)).setter(ModifyEndpointRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyEndpointRequest.getter(ModifyEndpointRequest::databaseName)).setter(ModifyEndpointRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> EXTRA_CONNECTION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyEndpointRequest.getter(ModifyEndpointRequest::extraConnectionAttributes)).setter(ModifyEndpointRequest.setter(Builder::extraConnectionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraConnectionAttributes").build()}).build();
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyEndpointRequest.getter(ModifyEndpointRequest::certificateArn)).setter(ModifyEndpointRequest.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()}).build();
    private static final SdkField<String> SSL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyEndpointRequest.getter(ModifyEndpointRequest::sslModeAsString)).setter(ModifyEndpointRequest.setter(Builder::sslMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslMode").build()}).build();
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyEndpointRequest.getter(ModifyEndpointRequest::serviceAccessRoleArn)).setter(ModifyEndpointRequest.setter(Builder::serviceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build()}).build();
    private static final SdkField<String> EXTERNAL_TABLE_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyEndpointRequest.getter(ModifyEndpointRequest::externalTableDefinition)).setter(ModifyEndpointRequest.setter(Builder::externalTableDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalTableDefinition").build()}).build();
    private static final SdkField<DynamoDbSettings> DYNAMO_DB_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifyEndpointRequest.getter(ModifyEndpointRequest::dynamoDbSettings)).setter(ModifyEndpointRequest.setter(Builder::dynamoDbSettings)).constructor(DynamoDbSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamoDbSettings").build()}).build();
    private static final SdkField<S3Settings> S3_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifyEndpointRequest.getter(ModifyEndpointRequest::s3Settings)).setter(ModifyEndpointRequest.setter(Builder::s3Settings)).constructor(S3Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Settings").build()}).build();
    private static final SdkField<DmsTransferSettings> DMS_TRANSFER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifyEndpointRequest.getter(ModifyEndpointRequest::dmsTransferSettings)).setter(ModifyEndpointRequest.setter(Builder::dmsTransferSettings)).constructor(DmsTransferSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DmsTransferSettings").build()}).build();
    private static final SdkField<MongoDbSettings> MONGO_DB_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifyEndpointRequest.getter(ModifyEndpointRequest::mongoDbSettings)).setter(ModifyEndpointRequest.setter(Builder::mongoDbSettings)).constructor(MongoDbSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MongoDbSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ARN_FIELD, ENDPOINT_IDENTIFIER_FIELD, ENDPOINT_TYPE_FIELD, ENGINE_NAME_FIELD, USERNAME_FIELD, PASSWORD_FIELD, SERVER_NAME_FIELD, PORT_FIELD, DATABASE_NAME_FIELD, EXTRA_CONNECTION_ATTRIBUTES_FIELD, CERTIFICATE_ARN_FIELD, SSL_MODE_FIELD, SERVICE_ACCESS_ROLE_ARN_FIELD, EXTERNAL_TABLE_DEFINITION_FIELD, DYNAMO_DB_SETTINGS_FIELD, S3_SETTINGS_FIELD, DMS_TRANSFER_SETTINGS_FIELD, MONGO_DB_SETTINGS_FIELD));
    private final String endpointArn;
    private final String endpointIdentifier;
    private final String endpointType;
    private final String engineName;
    private final String username;
    private final String password;
    private final String serverName;
    private final Integer port;
    private final String databaseName;
    private final String extraConnectionAttributes;
    private final String certificateArn;
    private final String sslMode;
    private final String serviceAccessRoleArn;
    private final String externalTableDefinition;
    private final DynamoDbSettings dynamoDbSettings;
    private final S3Settings s3Settings;
    private final DmsTransferSettings dmsTransferSettings;
    private final MongoDbSettings mongoDbSettings;

    private ModifyEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointArn = builder.endpointArn;
        this.endpointIdentifier = builder.endpointIdentifier;
        this.endpointType = builder.endpointType;
        this.engineName = builder.engineName;
        this.username = builder.username;
        this.password = builder.password;
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.databaseName = builder.databaseName;
        this.extraConnectionAttributes = builder.extraConnectionAttributes;
        this.certificateArn = builder.certificateArn;
        this.sslMode = builder.sslMode;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.externalTableDefinition = builder.externalTableDefinition;
        this.dynamoDbSettings = builder.dynamoDbSettings;
        this.s3Settings = builder.s3Settings;
        this.dmsTransferSettings = builder.dmsTransferSettings;
        this.mongoDbSettings = builder.mongoDbSettings;
    }

    public String endpointArn() {
        return this.endpointArn;
    }

    public String endpointIdentifier() {
        return this.endpointIdentifier;
    }

    public ReplicationEndpointTypeValue endpointType() {
        return ReplicationEndpointTypeValue.fromValue(this.endpointType);
    }

    public String endpointTypeAsString() {
        return this.endpointType;
    }

    public String engineName() {
        return this.engineName;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public String serverName() {
        return this.serverName;
    }

    public Integer port() {
        return this.port;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String extraConnectionAttributes() {
        return this.extraConnectionAttributes;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public DmsSslModeValue sslMode() {
        return DmsSslModeValue.fromValue(this.sslMode);
    }

    public String sslModeAsString() {
        return this.sslMode;
    }

    public String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public String externalTableDefinition() {
        return this.externalTableDefinition;
    }

    public DynamoDbSettings dynamoDbSettings() {
        return this.dynamoDbSettings;
    }

    public S3Settings s3Settings() {
        return this.s3Settings;
    }

    public DmsTransferSettings dmsTransferSettings() {
        return this.dmsTransferSettings;
    }

    public MongoDbSettings mongoDbSettings() {
        return this.mongoDbSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.extraConnectionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalTableDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamoDbSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.dmsTransferSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mongoDbSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyEndpointRequest)) {
            return false;
        }
        ModifyEndpointRequest other = (ModifyEndpointRequest)((Object)obj);
        return Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.endpointIdentifier(), other.endpointIdentifier()) && Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(this.engineName(), other.engineName()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.extraConnectionAttributes(), other.extraConnectionAttributes()) && Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.sslModeAsString(), other.sslModeAsString()) && Objects.equals(this.serviceAccessRoleArn(), other.serviceAccessRoleArn()) && Objects.equals(this.externalTableDefinition(), other.externalTableDefinition()) && Objects.equals(this.dynamoDbSettings(), other.dynamoDbSettings()) && Objects.equals(this.s3Settings(), other.s3Settings()) && Objects.equals(this.dmsTransferSettings(), other.dmsTransferSettings()) && Objects.equals(this.mongoDbSettings(), other.mongoDbSettings());
    }

    public String toString() {
        return ToString.builder((String)"ModifyEndpointRequest").add("EndpointArn", (Object)this.endpointArn()).add("EndpointIdentifier", (Object)this.endpointIdentifier()).add("EndpointType", (Object)this.endpointTypeAsString()).add("EngineName", (Object)this.engineName()).add("Username", (Object)this.username()).add("Password", (Object)this.password()).add("ServerName", (Object)this.serverName()).add("Port", (Object)this.port()).add("DatabaseName", (Object)this.databaseName()).add("ExtraConnectionAttributes", (Object)this.extraConnectionAttributes()).add("CertificateArn", (Object)this.certificateArn()).add("SslMode", (Object)this.sslModeAsString()).add("ServiceAccessRoleArn", (Object)this.serviceAccessRoleArn()).add("ExternalTableDefinition", (Object)this.externalTableDefinition()).add("DynamoDbSettings", (Object)this.dynamoDbSettings()).add("S3Settings", (Object)this.s3Settings()).add("DmsTransferSettings", (Object)this.dmsTransferSettings()).add("MongoDbSettings", (Object)this.mongoDbSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointArn": {
                return Optional.ofNullable(clazz.cast(this.endpointArn()));
            }
            case "EndpointIdentifier": {
                return Optional.ofNullable(clazz.cast(this.endpointIdentifier()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
            case "EngineName": {
                return Optional.ofNullable(clazz.cast(this.engineName()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "ExtraConnectionAttributes": {
                return Optional.ofNullable(clazz.cast(this.extraConnectionAttributes()));
            }
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "SslMode": {
                return Optional.ofNullable(clazz.cast(this.sslModeAsString()));
            }
            case "ServiceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessRoleArn()));
            }
            case "ExternalTableDefinition": {
                return Optional.ofNullable(clazz.cast(this.externalTableDefinition()));
            }
            case "DynamoDbSettings": {
                return Optional.ofNullable(clazz.cast(this.dynamoDbSettings()));
            }
            case "S3Settings": {
                return Optional.ofNullable(clazz.cast(this.s3Settings()));
            }
            case "DmsTransferSettings": {
                return Optional.ofNullable(clazz.cast(this.dmsTransferSettings()));
            }
            case "MongoDbSettings": {
                return Optional.ofNullable(clazz.cast(this.mongoDbSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyEndpointRequest, T> g) {
        return obj -> g.apply((ModifyEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String endpointArn;
        private String endpointIdentifier;
        private String endpointType;
        private String engineName;
        private String username;
        private String password;
        private String serverName;
        private Integer port;
        private String databaseName;
        private String extraConnectionAttributes;
        private String certificateArn;
        private String sslMode;
        private String serviceAccessRoleArn;
        private String externalTableDefinition;
        private DynamoDbSettings dynamoDbSettings;
        private S3Settings s3Settings;
        private DmsTransferSettings dmsTransferSettings;
        private MongoDbSettings mongoDbSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyEndpointRequest model) {
            super(model);
            this.endpointArn(model.endpointArn);
            this.endpointIdentifier(model.endpointIdentifier);
            this.endpointType(model.endpointType);
            this.engineName(model.engineName);
            this.username(model.username);
            this.password(model.password);
            this.serverName(model.serverName);
            this.port(model.port);
            this.databaseName(model.databaseName);
            this.extraConnectionAttributes(model.extraConnectionAttributes);
            this.certificateArn(model.certificateArn);
            this.sslMode(model.sslMode);
            this.serviceAccessRoleArn(model.serviceAccessRoleArn);
            this.externalTableDefinition(model.externalTableDefinition);
            this.dynamoDbSettings(model.dynamoDbSettings);
            this.s3Settings(model.s3Settings);
            this.dmsTransferSettings(model.dmsTransferSettings);
            this.mongoDbSettings(model.mongoDbSettings);
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        public final String getEndpointIdentifier() {
            return this.endpointIdentifier;
        }

        @Override
        public final Builder endpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
            return this;
        }

        public final void setEndpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(ReplicationEndpointTypeValue endpointType) {
            this.endpointType(endpointType.toString());
            return this;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        public final String getEngineName() {
            return this.engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getExtraConnectionAttributes() {
            return this.extraConnectionAttributes;
        }

        @Override
        public final Builder extraConnectionAttributes(String extraConnectionAttributes) {
            this.extraConnectionAttributes = extraConnectionAttributes;
            return this;
        }

        public final void setExtraConnectionAttributes(String extraConnectionAttributes) {
            this.extraConnectionAttributes = extraConnectionAttributes;
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getSslMode() {
            return this.sslMode;
        }

        @Override
        public final Builder sslMode(String sslMode) {
            this.sslMode = sslMode;
            return this;
        }

        @Override
        public final Builder sslMode(DmsSslModeValue sslMode) {
            this.sslMode(sslMode.toString());
            return this;
        }

        public final void setSslMode(String sslMode) {
            this.sslMode = sslMode;
        }

        public final String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        public final String getExternalTableDefinition() {
            return this.externalTableDefinition;
        }

        @Override
        public final Builder externalTableDefinition(String externalTableDefinition) {
            this.externalTableDefinition = externalTableDefinition;
            return this;
        }

        public final void setExternalTableDefinition(String externalTableDefinition) {
            this.externalTableDefinition = externalTableDefinition;
        }

        public final DynamoDbSettings.Builder getDynamoDbSettings() {
            return this.dynamoDbSettings != null ? this.dynamoDbSettings.toBuilder() : null;
        }

        @Override
        public final Builder dynamoDbSettings(DynamoDbSettings dynamoDbSettings) {
            this.dynamoDbSettings = dynamoDbSettings;
            return this;
        }

        public final void setDynamoDbSettings(DynamoDbSettings.BuilderImpl dynamoDbSettings) {
            this.dynamoDbSettings = dynamoDbSettings != null ? dynamoDbSettings.build() : null;
        }

        public final S3Settings.Builder getS3Settings() {
            return this.s3Settings != null ? this.s3Settings.toBuilder() : null;
        }

        @Override
        public final Builder s3Settings(S3Settings s3Settings) {
            this.s3Settings = s3Settings;
            return this;
        }

        public final void setS3Settings(S3Settings.BuilderImpl s3Settings) {
            this.s3Settings = s3Settings != null ? s3Settings.build() : null;
        }

        public final DmsTransferSettings.Builder getDmsTransferSettings() {
            return this.dmsTransferSettings != null ? this.dmsTransferSettings.toBuilder() : null;
        }

        @Override
        public final Builder dmsTransferSettings(DmsTransferSettings dmsTransferSettings) {
            this.dmsTransferSettings = dmsTransferSettings;
            return this;
        }

        public final void setDmsTransferSettings(DmsTransferSettings.BuilderImpl dmsTransferSettings) {
            this.dmsTransferSettings = dmsTransferSettings != null ? dmsTransferSettings.build() : null;
        }

        public final MongoDbSettings.Builder getMongoDbSettings() {
            return this.mongoDbSettings != null ? this.mongoDbSettings.toBuilder() : null;
        }

        @Override
        public final Builder mongoDbSettings(MongoDbSettings mongoDbSettings) {
            this.mongoDbSettings = mongoDbSettings;
            return this;
        }

        public final void setMongoDbSettings(MongoDbSettings.BuilderImpl mongoDbSettings) {
            this.mongoDbSettings = mongoDbSettings != null ? mongoDbSettings.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyEndpointRequest build() {
            return new ModifyEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyEndpointRequest> {
        public Builder endpointArn(String var1);

        public Builder endpointIdentifier(String var1);

        public Builder endpointType(String var1);

        public Builder endpointType(ReplicationEndpointTypeValue var1);

        public Builder engineName(String var1);

        public Builder username(String var1);

        public Builder password(String var1);

        public Builder serverName(String var1);

        public Builder port(Integer var1);

        public Builder databaseName(String var1);

        public Builder extraConnectionAttributes(String var1);

        public Builder certificateArn(String var1);

        public Builder sslMode(String var1);

        public Builder sslMode(DmsSslModeValue var1);

        public Builder serviceAccessRoleArn(String var1);

        public Builder externalTableDefinition(String var1);

        public Builder dynamoDbSettings(DynamoDbSettings var1);

        default public Builder dynamoDbSettings(Consumer<DynamoDbSettings.Builder> dynamoDbSettings) {
            return this.dynamoDbSettings((DynamoDbSettings)((DynamoDbSettings.Builder)DynamoDbSettings.builder().applyMutation(dynamoDbSettings)).build());
        }

        public Builder s3Settings(S3Settings var1);

        default public Builder s3Settings(Consumer<S3Settings.Builder> s3Settings) {
            return this.s3Settings((S3Settings)((S3Settings.Builder)S3Settings.builder().applyMutation(s3Settings)).build());
        }

        public Builder dmsTransferSettings(DmsTransferSettings var1);

        default public Builder dmsTransferSettings(Consumer<DmsTransferSettings.Builder> dmsTransferSettings) {
            return this.dmsTransferSettings((DmsTransferSettings)((DmsTransferSettings.Builder)DmsTransferSettings.builder().applyMutation(dmsTransferSettings)).build());
        }

        public Builder mongoDbSettings(MongoDbSettings var1);

        default public Builder mongoDbSettings(Consumer<MongoDbSettings.Builder> mongoDbSettings) {
            return this.mongoDbSettings((MongoDbSettings)((MongoDbSettings.Builder)MongoDbSettings.builder().applyMutation(mongoDbSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

