/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.TestConnectionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TestConnectionRequestModelMarshaller {
    private static final MarshallingInfo<String> REPLICATIONINSTANCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationInstanceArn").isBinary(false).build();
    private static final MarshallingInfo<String> ENDPOINTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointArn").isBinary(false).build();
    private static final TestConnectionRequestModelMarshaller INSTANCE = new TestConnectionRequestModelMarshaller();

    private TestConnectionRequestModelMarshaller() {
    }

    public static TestConnectionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TestConnectionRequest testConnectionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)testConnectionRequest), (String)"testConnectionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)testConnectionRequest.replicationInstanceArn(), REPLICATIONINSTANCEARN_BINDING);
            protocolMarshaller.marshall((Object)testConnectionRequest.endpointArn(), ENDPOINTARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

