/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.TableStatistics;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TableStatisticsMarshaller {
    private static final MarshallingInfo<String> SCHEMANAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaName").isBinary(false).build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<Long> INSERTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Inserts").isBinary(false).build();
    private static final MarshallingInfo<Long> DELETES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Deletes").isBinary(false).build();
    private static final MarshallingInfo<Long> UPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Updates").isBinary(false).build();
    private static final MarshallingInfo<Long> DDLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ddls").isBinary(false).build();
    private static final MarshallingInfo<Long> FULLLOADROWS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FullLoadRows").isBinary(false).build();
    private static final MarshallingInfo<Long> FULLLOADCONDTNLCHKFAILEDROWS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FullLoadCondtnlChkFailedRows").isBinary(false).build();
    private static final MarshallingInfo<Long> FULLLOADERRORROWS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FullLoadErrorRows").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateTime").isBinary(false).build();
    private static final MarshallingInfo<String> TABLESTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableState").isBinary(false).build();
    private static final MarshallingInfo<Long> VALIDATIONPENDINGRECORDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationPendingRecords").isBinary(false).build();
    private static final MarshallingInfo<Long> VALIDATIONFAILEDRECORDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationFailedRecords").isBinary(false).build();
    private static final MarshallingInfo<Long> VALIDATIONSUSPENDEDRECORDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationSuspendedRecords").isBinary(false).build();
    private static final MarshallingInfo<String> VALIDATIONSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationState").isBinary(false).build();
    private static final MarshallingInfo<String> VALIDATIONSTATEDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationStateDetails").isBinary(false).build();
    private static final TableStatisticsMarshaller INSTANCE = new TableStatisticsMarshaller();

    private TableStatisticsMarshaller() {
    }

    public static TableStatisticsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TableStatistics tableStatistics, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)tableStatistics, (String)"tableStatistics");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)tableStatistics.schemaName(), SCHEMANAME_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.inserts(), INSERTS_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.deletes(), DELETES_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.updates(), UPDATES_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.ddls(), DDLS_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.fullLoadRows(), FULLLOADROWS_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.fullLoadCondtnlChkFailedRows(), FULLLOADCONDTNLCHKFAILEDROWS_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.fullLoadErrorRows(), FULLLOADERRORROWS_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.lastUpdateTime(), LASTUPDATETIME_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.tableState(), TABLESTATE_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.validationPendingRecords(), VALIDATIONPENDINGRECORDS_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.validationFailedRecords(), VALIDATIONFAILEDRECORDS_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.validationSuspendedRecords(), VALIDATIONSUSPENDEDRECORDS_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.validationState(), VALIDATIONSTATE_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.validationStateDetails(), VALIDATIONSTATEDETAILS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

