/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.databasemigration.model.Subnet;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SubnetMarshaller {
    private static final MarshallingInfo<String> SUBNETIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetIdentifier").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SUBNETAVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetAvailabilityZone").isBinary(false).build();
    private static final MarshallingInfo<String> SUBNETSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetStatus").isBinary(false).build();
    private static final SubnetMarshaller INSTANCE = new SubnetMarshaller();

    private SubnetMarshaller() {
    }

    public static SubnetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Subnet subnet, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)subnet, (String)"subnet");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)subnet.subnetIdentifier(), SUBNETIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)subnet.subnetAvailabilityZone(), SUBNETAVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)subnet.subnetStatus(), SUBNETSTATUS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

