/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.ReplicationPendingModifiedValues;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReplicationPendingModifiedValuesMarshaller {
    private static final MarshallingInfo<String> REPLICATIONINSTANCECLASS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationInstanceClass").isBinary(false).build();
    private static final MarshallingInfo<Integer> ALLOCATEDSTORAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllocatedStorage").isBinary(false).build();
    private static final MarshallingInfo<Boolean> MULTIAZ_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MultiAZ").isBinary(false).build();
    private static final MarshallingInfo<String> ENGINEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineVersion").isBinary(false).build();
    private static final ReplicationPendingModifiedValuesMarshaller INSTANCE = new ReplicationPendingModifiedValuesMarshaller();

    private ReplicationPendingModifiedValuesMarshaller() {
    }

    public static ReplicationPendingModifiedValuesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReplicationPendingModifiedValues replicationPendingModifiedValues, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)replicationPendingModifiedValues, (String)"replicationPendingModifiedValues");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)replicationPendingModifiedValues.replicationInstanceClass(), REPLICATIONINSTANCECLASS_BINDING);
            protocolMarshaller.marshall((Object)replicationPendingModifiedValues.allocatedStorage(), ALLOCATEDSTORAGE_BINDING);
            protocolMarshaller.marshall((Object)replicationPendingModifiedValues.multiAZ(), MULTIAZ_BINDING);
            protocolMarshaller.marshall((Object)replicationPendingModifiedValues.engineVersion(), ENGINEVERSION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

