/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.databasemigration.model.ReplicationInstance;
import software.amazon.awssdk.services.databasemigration.transform.ReplicationPendingModifiedValuesUnmarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ReplicationSubnetGroupUnmarshaller;
import software.amazon.awssdk.services.databasemigration.transform.VpcSecurityGroupMembershipUnmarshaller;

public class ReplicationInstanceUnmarshaller
implements Unmarshaller<ReplicationInstance, JsonUnmarshallerContext> {
    private static final ReplicationInstanceUnmarshaller INSTANCE = new ReplicationInstanceUnmarshaller();

    public ReplicationInstance unmarshall(JsonUnmarshallerContext context) throws Exception {
        ReplicationInstance.Builder replicationInstanceBuilder = ReplicationInstance.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ReplicationInstanceIdentifier", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.replicationInstanceIdentifier((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ReplicationInstanceClass", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.replicationInstanceClass((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ReplicationInstanceStatus", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.replicationInstanceStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AllocatedStorage", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.allocatedStorage((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("InstanceCreateTime", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.instanceCreateTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("VpcSecurityGroups", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.vpcSecurityGroups(new ListUnmarshaller((Unmarshaller)VpcSecurityGroupMembershipUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("AvailabilityZone", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.availabilityZone((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ReplicationSubnetGroup", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.replicationSubnetGroup(ReplicationSubnetGroupUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("PreferredMaintenanceWindow", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.preferredMaintenanceWindow((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("PendingModifiedValues", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.pendingModifiedValues(ReplicationPendingModifiedValuesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("MultiAZ", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.multiAZ((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("EngineVersion", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.engineVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AutoMinorVersionUpgrade", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.autoMinorVersionUpgrade((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("KmsKeyId", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.kmsKeyId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ReplicationInstanceArn", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.replicationInstanceArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ReplicationInstancePublicIpAddress", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.replicationInstancePublicIpAddress((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ReplicationInstancePrivateIpAddress", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.replicationInstancePrivateIpAddress((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ReplicationInstancePublicIpAddresses", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.replicationInstancePublicIpAddresses(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("ReplicationInstancePrivateIpAddresses", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.replicationInstancePrivateIpAddresses(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("PubliclyAccessible", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.publiclyAccessible((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("SecondaryAvailabilityZone", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.secondaryAvailabilityZone((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("FreeUntil", targetDepth)) {
                    context.nextToken();
                    replicationInstanceBuilder.freeUntil((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ReplicationInstance)replicationInstanceBuilder.build();
    }

    public static ReplicationInstanceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

