/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.ReplicationInstanceTaskLog;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReplicationInstanceTaskLogMarshaller {
    private static final MarshallingInfo<String> REPLICATIONTASKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationTaskName").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICATIONTASKARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationTaskArn").isBinary(false).build();
    private static final MarshallingInfo<Long> REPLICATIONINSTANCETASKLOGSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationInstanceTaskLogSize").isBinary(false).build();
    private static final ReplicationInstanceTaskLogMarshaller INSTANCE = new ReplicationInstanceTaskLogMarshaller();

    private ReplicationInstanceTaskLogMarshaller() {
    }

    public static ReplicationInstanceTaskLogMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReplicationInstanceTaskLog replicationInstanceTaskLog, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)replicationInstanceTaskLog, (String)"replicationInstanceTaskLog");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)replicationInstanceTaskLog.replicationTaskName(), REPLICATIONTASKNAME_BINDING);
            protocolMarshaller.marshall((Object)replicationInstanceTaskLog.replicationTaskArn(), REPLICATIONTASKARN_BINDING);
            protocolMarshaller.marshall((Object)replicationInstanceTaskLog.replicationInstanceTaskLogSize(), REPLICATIONINSTANCETASKLOGSIZE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

