/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.ReloadTablesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReloadTablesRequestModelMarshaller {
    private static final MarshallingInfo<String> REPLICATIONTASKARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationTaskArn").isBinary(false).build();
    private static final MarshallingInfo<List> TABLESTORELOAD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TablesToReload").isBinary(false).build();
    private static final MarshallingInfo<String> RELOADOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReloadOption").isBinary(false).build();
    private static final ReloadTablesRequestModelMarshaller INSTANCE = new ReloadTablesRequestModelMarshaller();

    private ReloadTablesRequestModelMarshaller() {
    }

    public static ReloadTablesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReloadTablesRequest reloadTablesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)reloadTablesRequest), (String)"reloadTablesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)reloadTablesRequest.replicationTaskArn(), REPLICATIONTASKARN_BINDING);
            protocolMarshaller.marshall(reloadTablesRequest.tablesToReload(), TABLESTORELOAD_BINDING);
            protocolMarshaller.marshall((Object)reloadTablesRequest.reloadOptionAsString(), RELOADOPTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

