/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ModifyReplicationTaskRequestModelMarshaller {
    private static final MarshallingInfo<String> REPLICATIONTASKARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationTaskArn").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICATIONTASKIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationTaskIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> MIGRATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MigrationType").isBinary(false).build();
    private static final MarshallingInfo<String> TABLEMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableMappings").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICATIONTASKSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationTaskSettings").isBinary(false).build();
    private static final MarshallingInfo<Instant> CDCSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CdcStartTime").isBinary(false).build();
    private static final MarshallingInfo<String> CDCSTARTPOSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CdcStartPosition").isBinary(false).build();
    private static final MarshallingInfo<String> CDCSTOPPOSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CdcStopPosition").isBinary(false).build();
    private static final ModifyReplicationTaskRequestModelMarshaller INSTANCE = new ModifyReplicationTaskRequestModelMarshaller();

    private ModifyReplicationTaskRequestModelMarshaller() {
    }

    public static ModifyReplicationTaskRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ModifyReplicationTaskRequest modifyReplicationTaskRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)modifyReplicationTaskRequest), (String)"modifyReplicationTaskRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)modifyReplicationTaskRequest.replicationTaskArn(), REPLICATIONTASKARN_BINDING);
            protocolMarshaller.marshall((Object)modifyReplicationTaskRequest.replicationTaskIdentifier(), REPLICATIONTASKIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)modifyReplicationTaskRequest.migrationTypeAsString(), MIGRATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)modifyReplicationTaskRequest.tableMappings(), TABLEMAPPINGS_BINDING);
            protocolMarshaller.marshall((Object)modifyReplicationTaskRequest.replicationTaskSettings(), REPLICATIONTASKSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)modifyReplicationTaskRequest.cdcStartTime(), CDCSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)modifyReplicationTaskRequest.cdcStartPosition(), CDCSTARTPOSITION_BINDING);
            protocolMarshaller.marshall((Object)modifyReplicationTaskRequest.cdcStopPosition(), CDCSTOPPOSITION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

