/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.Event;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EventMarshaller {
    private static final MarshallingInfo<String> SOURCEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceType").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").isBinary(false).build();
    private static final MarshallingInfo<List> EVENTCATEGORIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventCategories").isBinary(false).build();
    private static final MarshallingInfo<Instant> DATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Date").isBinary(false).build();
    private static final EventMarshaller INSTANCE = new EventMarshaller();

    private EventMarshaller() {
    }

    public static EventMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Event event, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)event, (String)"event");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)event.sourceIdentifier(), SOURCEIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)event.sourceTypeAsString(), SOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)event.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall(event.eventCategories(), EVENTCATEGORIES_BINDING);
            protocolMarshaller.marshall((Object)event.date(), DATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

