/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.databasemigration.model.DynamoDbSettings;

public class DynamoDbSettingsUnmarshaller
implements Unmarshaller<DynamoDbSettings, JsonUnmarshallerContext> {
    private static final DynamoDbSettingsUnmarshaller INSTANCE = new DynamoDbSettingsUnmarshaller();

    public DynamoDbSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        DynamoDbSettings.Builder dynamoDbSettingsBuilder = DynamoDbSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ServiceAccessRoleArn", targetDepth)) {
                    context.nextToken();
                    dynamoDbSettingsBuilder.serviceAccessRoleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DynamoDbSettings)dynamoDbSettingsBuilder.build();
    }

    public static DynamoDbSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

