/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.DynamoDbSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DynamoDbSettingsMarshaller {
    private static final MarshallingInfo<String> SERVICEACCESSROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceAccessRoleArn").isBinary(false).build();
    private static final DynamoDbSettingsMarshaller INSTANCE = new DynamoDbSettingsMarshaller();

    private DynamoDbSettingsMarshaller() {
    }

    public static DynamoDbSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DynamoDbSettings dynamoDbSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dynamoDbSettings, (String)"dynamoDbSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dynamoDbSettings.serviceAccessRoleArn(), SERVICEACCESSROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

