/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestConnectionRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, TestConnectionRequest> {
    private final String replicationInstanceArn;
    private final String endpointArn;

    private TestConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.endpointArn = builder.endpointArn;
    }

    public String replicationInstanceArn() {
        return this.replicationInstanceArn;
    }

    public String endpointArn() {
        return this.endpointArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestConnectionRequest)) {
            return false;
        }
        TestConnectionRequest other = (TestConnectionRequest)((Object)obj);
        return Objects.equals(this.replicationInstanceArn(), other.replicationInstanceArn()) && Objects.equals(this.endpointArn(), other.endpointArn());
    }

    public String toString() {
        return ToString.builder((String)"TestConnectionRequest").add("ReplicationInstanceArn", (Object)this.replicationInstanceArn()).add("EndpointArn", (Object)this.endpointArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceArn()));
            }
            case "EndpointArn": {
                return Optional.ofNullable(clazz.cast(this.endpointArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String replicationInstanceArn;
        private String endpointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TestConnectionRequest model) {
            super(model);
            this.replicationInstanceArn(model.replicationInstanceArn);
            this.endpointArn(model.endpointArn);
        }

        public final String getReplicationInstanceArn() {
            return this.replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestConnectionRequest build() {
            return new TestConnectionRequest(this);
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    CopyableBuilder<Builder, TestConnectionRequest> {
        public Builder replicationInstanceArn(String var1);

        public Builder endpointArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

