/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.databasemigration.transform.ReplicationTaskAssessmentResultMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationTaskAssessmentResult
implements StructuredPojo,
ToCopyableBuilder<Builder, ReplicationTaskAssessmentResult> {
    private final String replicationTaskIdentifier;
    private final String replicationTaskArn;
    private final Instant replicationTaskLastAssessmentDate;
    private final String assessmentStatus;
    private final String assessmentResultsFile;
    private final String assessmentResults;
    private final String s3ObjectUrl;

    private ReplicationTaskAssessmentResult(BuilderImpl builder) {
        this.replicationTaskIdentifier = builder.replicationTaskIdentifier;
        this.replicationTaskArn = builder.replicationTaskArn;
        this.replicationTaskLastAssessmentDate = builder.replicationTaskLastAssessmentDate;
        this.assessmentStatus = builder.assessmentStatus;
        this.assessmentResultsFile = builder.assessmentResultsFile;
        this.assessmentResults = builder.assessmentResults;
        this.s3ObjectUrl = builder.s3ObjectUrl;
    }

    public String replicationTaskIdentifier() {
        return this.replicationTaskIdentifier;
    }

    public String replicationTaskArn() {
        return this.replicationTaskArn;
    }

    public Instant replicationTaskLastAssessmentDate() {
        return this.replicationTaskLastAssessmentDate;
    }

    public String assessmentStatus() {
        return this.assessmentStatus;
    }

    public String assessmentResultsFile() {
        return this.assessmentResultsFile;
    }

    public String assessmentResults() {
        return this.assessmentResults;
    }

    public String s3ObjectUrl() {
        return this.s3ObjectUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskLastAssessmentDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentResultsFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ObjectUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationTaskAssessmentResult)) {
            return false;
        }
        ReplicationTaskAssessmentResult other = (ReplicationTaskAssessmentResult)obj;
        return Objects.equals(this.replicationTaskIdentifier(), other.replicationTaskIdentifier()) && Objects.equals(this.replicationTaskArn(), other.replicationTaskArn()) && Objects.equals(this.replicationTaskLastAssessmentDate(), other.replicationTaskLastAssessmentDate()) && Objects.equals(this.assessmentStatus(), other.assessmentStatus()) && Objects.equals(this.assessmentResultsFile(), other.assessmentResultsFile()) && Objects.equals(this.assessmentResults(), other.assessmentResults()) && Objects.equals(this.s3ObjectUrl(), other.s3ObjectUrl());
    }

    public String toString() {
        return ToString.builder((String)"ReplicationTaskAssessmentResult").add("ReplicationTaskIdentifier", (Object)this.replicationTaskIdentifier()).add("ReplicationTaskArn", (Object)this.replicationTaskArn()).add("ReplicationTaskLastAssessmentDate", (Object)this.replicationTaskLastAssessmentDate()).add("AssessmentStatus", (Object)this.assessmentStatus()).add("AssessmentResultsFile", (Object)this.assessmentResultsFile()).add("AssessmentResults", (Object)this.assessmentResults()).add("S3ObjectUrl", (Object)this.s3ObjectUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationTaskIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskIdentifier()));
            }
            case "ReplicationTaskArn": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskArn()));
            }
            case "ReplicationTaskLastAssessmentDate": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskLastAssessmentDate()));
            }
            case "AssessmentStatus": {
                return Optional.ofNullable(clazz.cast(this.assessmentStatus()));
            }
            case "AssessmentResultsFile": {
                return Optional.ofNullable(clazz.cast(this.assessmentResultsFile()));
            }
            case "AssessmentResults": {
                return Optional.ofNullable(clazz.cast(this.assessmentResults()));
            }
            case "S3ObjectUrl": {
                return Optional.ofNullable(clazz.cast(this.s3ObjectUrl()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplicationTaskAssessmentResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationTaskIdentifier;
        private String replicationTaskArn;
        private Instant replicationTaskLastAssessmentDate;
        private String assessmentStatus;
        private String assessmentResultsFile;
        private String assessmentResults;
        private String s3ObjectUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationTaskAssessmentResult model) {
            this.replicationTaskIdentifier(model.replicationTaskIdentifier);
            this.replicationTaskArn(model.replicationTaskArn);
            this.replicationTaskLastAssessmentDate(model.replicationTaskLastAssessmentDate);
            this.assessmentStatus(model.assessmentStatus);
            this.assessmentResultsFile(model.assessmentResultsFile);
            this.assessmentResults(model.assessmentResults);
            this.s3ObjectUrl(model.s3ObjectUrl);
        }

        public final String getReplicationTaskIdentifier() {
            return this.replicationTaskIdentifier;
        }

        @Override
        public final Builder replicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
            return this;
        }

        public final void setReplicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
        }

        public final String getReplicationTaskArn() {
            return this.replicationTaskArn;
        }

        @Override
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        public final Instant getReplicationTaskLastAssessmentDate() {
            return this.replicationTaskLastAssessmentDate;
        }

        @Override
        public final Builder replicationTaskLastAssessmentDate(Instant replicationTaskLastAssessmentDate) {
            this.replicationTaskLastAssessmentDate = replicationTaskLastAssessmentDate;
            return this;
        }

        public final void setReplicationTaskLastAssessmentDate(Instant replicationTaskLastAssessmentDate) {
            this.replicationTaskLastAssessmentDate = replicationTaskLastAssessmentDate;
        }

        public final String getAssessmentStatus() {
            return this.assessmentStatus;
        }

        @Override
        public final Builder assessmentStatus(String assessmentStatus) {
            this.assessmentStatus = assessmentStatus;
            return this;
        }

        public final void setAssessmentStatus(String assessmentStatus) {
            this.assessmentStatus = assessmentStatus;
        }

        public final String getAssessmentResultsFile() {
            return this.assessmentResultsFile;
        }

        @Override
        public final Builder assessmentResultsFile(String assessmentResultsFile) {
            this.assessmentResultsFile = assessmentResultsFile;
            return this;
        }

        public final void setAssessmentResultsFile(String assessmentResultsFile) {
            this.assessmentResultsFile = assessmentResultsFile;
        }

        public final String getAssessmentResults() {
            return this.assessmentResults;
        }

        @Override
        public final Builder assessmentResults(String assessmentResults) {
            this.assessmentResults = assessmentResults;
            return this;
        }

        public final void setAssessmentResults(String assessmentResults) {
            this.assessmentResults = assessmentResults;
        }

        public final String getS3ObjectUrl() {
            return this.s3ObjectUrl;
        }

        @Override
        public final Builder s3ObjectUrl(String s3ObjectUrl) {
            this.s3ObjectUrl = s3ObjectUrl;
            return this;
        }

        public final void setS3ObjectUrl(String s3ObjectUrl) {
            this.s3ObjectUrl = s3ObjectUrl;
        }

        public ReplicationTaskAssessmentResult build() {
            return new ReplicationTaskAssessmentResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReplicationTaskAssessmentResult> {
        public Builder replicationTaskIdentifier(String var1);

        public Builder replicationTaskArn(String var1);

        public Builder replicationTaskLastAssessmentDate(Instant var1);

        public Builder assessmentStatus(String var1);

        public Builder assessmentResultsFile(String var1);

        public Builder assessmentResults(String var1);

        public Builder s3ObjectUrl(String var1);
    }
}

