/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RebootReplicationInstanceRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, RebootReplicationInstanceRequest> {
    private final String replicationInstanceArn;
    private final Boolean forceFailover;

    private RebootReplicationInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.forceFailover = builder.forceFailover;
    }

    public String replicationInstanceArn() {
        return this.replicationInstanceArn;
    }

    public Boolean forceFailover() {
        return this.forceFailover;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceFailover());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebootReplicationInstanceRequest)) {
            return false;
        }
        RebootReplicationInstanceRequest other = (RebootReplicationInstanceRequest)((Object)obj);
        return Objects.equals(this.replicationInstanceArn(), other.replicationInstanceArn()) && Objects.equals(this.forceFailover(), other.forceFailover());
    }

    public String toString() {
        return ToString.builder((String)"RebootReplicationInstanceRequest").add("ReplicationInstanceArn", (Object)this.replicationInstanceArn()).add("ForceFailover", (Object)this.forceFailover()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceArn()));
            }
            case "ForceFailover": {
                return Optional.ofNullable(clazz.cast(this.forceFailover()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String replicationInstanceArn;
        private Boolean forceFailover;

        private BuilderImpl() {
        }

        private BuilderImpl(RebootReplicationInstanceRequest model) {
            super(model);
            this.replicationInstanceArn(model.replicationInstanceArn);
            this.forceFailover(model.forceFailover);
        }

        public final String getReplicationInstanceArn() {
            return this.replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        public final Boolean getForceFailover() {
            return this.forceFailover;
        }

        @Override
        public final Builder forceFailover(Boolean forceFailover) {
            this.forceFailover = forceFailover;
            return this;
        }

        public final void setForceFailover(Boolean forceFailover) {
            this.forceFailover = forceFailover;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RebootReplicationInstanceRequest build() {
            return new RebootReplicationInstanceRequest(this);
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    CopyableBuilder<Builder, RebootReplicationInstanceRequest> {
        public Builder replicationInstanceArn(String var1);

        public Builder forceFailover(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

