/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.databasemigration.transform.OrderableReplicationInstanceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrderableReplicationInstance
implements StructuredPojo,
ToCopyableBuilder<Builder, OrderableReplicationInstance> {
    private final String engineVersion;
    private final String replicationInstanceClass;
    private final String storageType;
    private final Integer minAllocatedStorage;
    private final Integer maxAllocatedStorage;
    private final Integer defaultAllocatedStorage;
    private final Integer includedAllocatedStorage;

    private OrderableReplicationInstance(BuilderImpl builder) {
        this.engineVersion = builder.engineVersion;
        this.replicationInstanceClass = builder.replicationInstanceClass;
        this.storageType = builder.storageType;
        this.minAllocatedStorage = builder.minAllocatedStorage;
        this.maxAllocatedStorage = builder.maxAllocatedStorage;
        this.defaultAllocatedStorage = builder.defaultAllocatedStorage;
        this.includedAllocatedStorage = builder.includedAllocatedStorage;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String replicationInstanceClass() {
        return this.replicationInstanceClass;
    }

    public String storageType() {
        return this.storageType;
    }

    public Integer minAllocatedStorage() {
        return this.minAllocatedStorage;
    }

    public Integer maxAllocatedStorage() {
        return this.maxAllocatedStorage;
    }

    public Integer defaultAllocatedStorage() {
        return this.defaultAllocatedStorage;
    }

    public Integer includedAllocatedStorage() {
        return this.includedAllocatedStorage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.minAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.includedAllocatedStorage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderableReplicationInstance)) {
            return false;
        }
        OrderableReplicationInstance other = (OrderableReplicationInstance)obj;
        return Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.replicationInstanceClass(), other.replicationInstanceClass()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.minAllocatedStorage(), other.minAllocatedStorage()) && Objects.equals(this.maxAllocatedStorage(), other.maxAllocatedStorage()) && Objects.equals(this.defaultAllocatedStorage(), other.defaultAllocatedStorage()) && Objects.equals(this.includedAllocatedStorage(), other.includedAllocatedStorage());
    }

    public String toString() {
        return ToString.builder((String)"OrderableReplicationInstance").add("EngineVersion", (Object)this.engineVersion()).add("ReplicationInstanceClass", (Object)this.replicationInstanceClass()).add("StorageType", (Object)this.storageType()).add("MinAllocatedStorage", (Object)this.minAllocatedStorage()).add("MaxAllocatedStorage", (Object)this.maxAllocatedStorage()).add("DefaultAllocatedStorage", (Object)this.defaultAllocatedStorage()).add("IncludedAllocatedStorage", (Object)this.includedAllocatedStorage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "ReplicationInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceClass()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "MinAllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.minAllocatedStorage()));
            }
            case "MaxAllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.maxAllocatedStorage()));
            }
            case "DefaultAllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.defaultAllocatedStorage()));
            }
            case "IncludedAllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.includedAllocatedStorage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OrderableReplicationInstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String engineVersion;
        private String replicationInstanceClass;
        private String storageType;
        private Integer minAllocatedStorage;
        private Integer maxAllocatedStorage;
        private Integer defaultAllocatedStorage;
        private Integer includedAllocatedStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(OrderableReplicationInstance model) {
            this.engineVersion(model.engineVersion);
            this.replicationInstanceClass(model.replicationInstanceClass);
            this.storageType(model.storageType);
            this.minAllocatedStorage(model.minAllocatedStorage);
            this.maxAllocatedStorage(model.maxAllocatedStorage);
            this.defaultAllocatedStorage(model.defaultAllocatedStorage);
            this.includedAllocatedStorage(model.includedAllocatedStorage);
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getReplicationInstanceClass() {
            return this.replicationInstanceClass;
        }

        @Override
        public final Builder replicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
            return this;
        }

        public final void setReplicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final Integer getMinAllocatedStorage() {
            return this.minAllocatedStorage;
        }

        @Override
        public final Builder minAllocatedStorage(Integer minAllocatedStorage) {
            this.minAllocatedStorage = minAllocatedStorage;
            return this;
        }

        public final void setMinAllocatedStorage(Integer minAllocatedStorage) {
            this.minAllocatedStorage = minAllocatedStorage;
        }

        public final Integer getMaxAllocatedStorage() {
            return this.maxAllocatedStorage;
        }

        @Override
        public final Builder maxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        public final void setMaxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
        }

        public final Integer getDefaultAllocatedStorage() {
            return this.defaultAllocatedStorage;
        }

        @Override
        public final Builder defaultAllocatedStorage(Integer defaultAllocatedStorage) {
            this.defaultAllocatedStorage = defaultAllocatedStorage;
            return this;
        }

        public final void setDefaultAllocatedStorage(Integer defaultAllocatedStorage) {
            this.defaultAllocatedStorage = defaultAllocatedStorage;
        }

        public final Integer getIncludedAllocatedStorage() {
            return this.includedAllocatedStorage;
        }

        @Override
        public final Builder includedAllocatedStorage(Integer includedAllocatedStorage) {
            this.includedAllocatedStorage = includedAllocatedStorage;
            return this;
        }

        public final void setIncludedAllocatedStorage(Integer includedAllocatedStorage) {
            this.includedAllocatedStorage = includedAllocatedStorage;
        }

        public OrderableReplicationInstance build() {
            return new OrderableReplicationInstance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OrderableReplicationInstance> {
        public Builder engineVersion(String var1);

        public Builder replicationInstanceClass(String var1);

        public Builder storageType(String var1);

        public Builder minAllocatedStorage(Integer var1);

        public Builder maxAllocatedStorage(Integer var1);

        public Builder defaultAllocatedStorage(Integer var1);

        public Builder includedAllocatedStorage(Integer var1);
    }
}

