/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.SubnetIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyReplicationSubnetGroupRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, ModifyReplicationSubnetGroupRequest> {
    private final String replicationSubnetGroupIdentifier;
    private final String replicationSubnetGroupDescription;
    private final List<String> subnetIds;

    private ModifyReplicationSubnetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.replicationSubnetGroupIdentifier = builder.replicationSubnetGroupIdentifier;
        this.replicationSubnetGroupDescription = builder.replicationSubnetGroupDescription;
        this.subnetIds = builder.subnetIds;
    }

    public String replicationSubnetGroupIdentifier() {
        return this.replicationSubnetGroupIdentifier;
    }

    public String replicationSubnetGroupDescription() {
        return this.replicationSubnetGroupDescription;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSubnetGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSubnetGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReplicationSubnetGroupRequest)) {
            return false;
        }
        ModifyReplicationSubnetGroupRequest other = (ModifyReplicationSubnetGroupRequest)((Object)obj);
        return Objects.equals(this.replicationSubnetGroupIdentifier(), other.replicationSubnetGroupIdentifier()) && Objects.equals(this.replicationSubnetGroupDescription(), other.replicationSubnetGroupDescription()) && Objects.equals(this.subnetIds(), other.subnetIds());
    }

    public String toString() {
        return ToString.builder((String)"ModifyReplicationSubnetGroupRequest").add("ReplicationSubnetGroupIdentifier", (Object)this.replicationSubnetGroupIdentifier()).add("ReplicationSubnetGroupDescription", (Object)this.replicationSubnetGroupDescription()).add("SubnetIds", this.subnetIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationSubnetGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationSubnetGroupIdentifier()));
            }
            case "ReplicationSubnetGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.replicationSubnetGroupDescription()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String replicationSubnetGroupIdentifier;
        private String replicationSubnetGroupDescription;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReplicationSubnetGroupRequest model) {
            super(model);
            this.replicationSubnetGroupIdentifier(model.replicationSubnetGroupIdentifier);
            this.replicationSubnetGroupDescription(model.replicationSubnetGroupDescription);
            this.subnetIds(model.subnetIds);
        }

        public final String getReplicationSubnetGroupIdentifier() {
            return this.replicationSubnetGroupIdentifier;
        }

        @Override
        public final Builder replicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier) {
            this.replicationSubnetGroupIdentifier = replicationSubnetGroupIdentifier;
            return this;
        }

        public final void setReplicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier) {
            this.replicationSubnetGroupIdentifier = replicationSubnetGroupIdentifier;
        }

        public final String getReplicationSubnetGroupDescription() {
            return this.replicationSubnetGroupDescription;
        }

        @Override
        public final Builder replicationSubnetGroupDescription(String replicationSubnetGroupDescription) {
            this.replicationSubnetGroupDescription = replicationSubnetGroupDescription;
            return this;
        }

        public final void setReplicationSubnetGroupDescription(String replicationSubnetGroupDescription) {
            this.replicationSubnetGroupDescription = replicationSubnetGroupDescription;
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyReplicationSubnetGroupRequest build() {
            return new ModifyReplicationSubnetGroupRequest(this);
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    CopyableBuilder<Builder, ModifyReplicationSubnetGroupRequest> {
        public Builder replicationSubnetGroupIdentifier(String var1);

        public Builder replicationSubnetGroupDescription(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

