/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.ReplicationInstance;
import software.amazon.awssdk.services.databasemigration.model.ReplicationInstanceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReplicationInstancesResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeReplicationInstancesResponse> {
    private final String marker;
    private final List<ReplicationInstance> replicationInstances;

    private DescribeReplicationInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.replicationInstances = builder.replicationInstances;
    }

    public String marker() {
        return this.marker;
    }

    public List<ReplicationInstance> replicationInstances() {
        return this.replicationInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationInstancesResponse)) {
            return false;
        }
        DescribeReplicationInstancesResponse other = (DescribeReplicationInstancesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.replicationInstances(), other.replicationInstances());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReplicationInstancesResponse").add("Marker", (Object)this.marker()).add("ReplicationInstances", this.replicationInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ReplicationInstances": {
                return Optional.ofNullable(clazz.cast(this.replicationInstances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReplicationInstance> replicationInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationInstancesResponse model) {
            super(model);
            this.marker(model.marker);
            this.replicationInstances(model.replicationInstances);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReplicationInstance.Builder> getReplicationInstances() {
            return this.replicationInstances != null ? (Collection)this.replicationInstances.stream().map(ReplicationInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationInstances(Collection<ReplicationInstance> replicationInstances) {
            this.replicationInstances = ReplicationInstanceListCopier.copy(replicationInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInstances(ReplicationInstance ... replicationInstances) {
            this.replicationInstances(Arrays.asList(replicationInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInstances(Consumer<ReplicationInstance.Builder> ... replicationInstances) {
            this.replicationInstances(Stream.of(replicationInstances).map(c -> (ReplicationInstance)((ReplicationInstance.Builder)ReplicationInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationInstances(Collection<ReplicationInstance.BuilderImpl> replicationInstances) {
            this.replicationInstances = ReplicationInstanceListCopier.copyFromBuilder(replicationInstances);
        }

        @Override
        public DescribeReplicationInstancesResponse build() {
            return new DescribeReplicationInstancesResponse(this);
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    CopyableBuilder<Builder, DescribeReplicationInstancesResponse> {
        public Builder marker(String var1);

        public Builder replicationInstances(Collection<ReplicationInstance> var1);

        public Builder replicationInstances(ReplicationInstance ... var1);

        public Builder replicationInstances(Consumer<ReplicationInstance.Builder> ... var1);
    }
}

