/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.AccountQuota;
import software.amazon.awssdk.services.databasemigration.model.AccountQuotaListCopier;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccountAttributesResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeAccountAttributesResponse> {
    private final List<AccountQuota> accountQuotas;

    private DescribeAccountAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.accountQuotas = builder.accountQuotas;
    }

    public List<AccountQuota> accountQuotas() {
        return this.accountQuotas;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountQuotas());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAttributesResponse)) {
            return false;
        }
        DescribeAccountAttributesResponse other = (DescribeAccountAttributesResponse)((Object)obj);
        return Objects.equals(this.accountQuotas(), other.accountQuotas());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAccountAttributesResponse").add("AccountQuotas", this.accountQuotas()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountQuotas": {
                return Optional.ofNullable(clazz.cast(this.accountQuotas()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private List<AccountQuota> accountQuotas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAttributesResponse model) {
            super(model);
            this.accountQuotas(model.accountQuotas);
        }

        public final Collection<AccountQuota.Builder> getAccountQuotas() {
            return this.accountQuotas != null ? (Collection)this.accountQuotas.stream().map(AccountQuota::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountQuotas(Collection<AccountQuota> accountQuotas) {
            this.accountQuotas = AccountQuotaListCopier.copy(accountQuotas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountQuotas(AccountQuota ... accountQuotas) {
            this.accountQuotas(Arrays.asList(accountQuotas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountQuotas(Consumer<AccountQuota.Builder> ... accountQuotas) {
            this.accountQuotas(Stream.of(accountQuotas).map(c -> (AccountQuota)((AccountQuota.Builder)AccountQuota.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccountQuotas(Collection<AccountQuota.BuilderImpl> accountQuotas) {
            this.accountQuotas = AccountQuotaListCopier.copyFromBuilder(accountQuotas);
        }

        @Override
        public DescribeAccountAttributesResponse build() {
            return new DescribeAccountAttributesResponse(this);
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    CopyableBuilder<Builder, DescribeAccountAttributesResponse> {
        public Builder accountQuotas(Collection<AccountQuota> var1);

        public Builder accountQuotas(AccountQuota ... var1);

        public Builder accountQuotas(Consumer<AccountQuota.Builder> ... var1);
    }
}

