/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.SubnetIdentifierListCopier;
import software.amazon.awssdk.services.databasemigration.model.Tag;
import software.amazon.awssdk.services.databasemigration.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReplicationSubnetGroupRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, CreateReplicationSubnetGroupRequest> {
    private final String replicationSubnetGroupIdentifier;
    private final String replicationSubnetGroupDescription;
    private final List<String> subnetIds;
    private final List<Tag> tags;

    private CreateReplicationSubnetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.replicationSubnetGroupIdentifier = builder.replicationSubnetGroupIdentifier;
        this.replicationSubnetGroupDescription = builder.replicationSubnetGroupDescription;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
    }

    public String replicationSubnetGroupIdentifier() {
        return this.replicationSubnetGroupIdentifier;
    }

    public String replicationSubnetGroupDescription() {
        return this.replicationSubnetGroupDescription;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSubnetGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSubnetGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationSubnetGroupRequest)) {
            return false;
        }
        CreateReplicationSubnetGroupRequest other = (CreateReplicationSubnetGroupRequest)((Object)obj);
        return Objects.equals(this.replicationSubnetGroupIdentifier(), other.replicationSubnetGroupIdentifier()) && Objects.equals(this.replicationSubnetGroupDescription(), other.replicationSubnetGroupDescription()) && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateReplicationSubnetGroupRequest").add("ReplicationSubnetGroupIdentifier", (Object)this.replicationSubnetGroupIdentifier()).add("ReplicationSubnetGroupDescription", (Object)this.replicationSubnetGroupDescription()).add("SubnetIds", this.subnetIds()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationSubnetGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationSubnetGroupIdentifier()));
            }
            case "ReplicationSubnetGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.replicationSubnetGroupDescription()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String replicationSubnetGroupIdentifier;
        private String replicationSubnetGroupDescription;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationSubnetGroupRequest model) {
            super(model);
            this.replicationSubnetGroupIdentifier(model.replicationSubnetGroupIdentifier);
            this.replicationSubnetGroupDescription(model.replicationSubnetGroupDescription);
            this.subnetIds(model.subnetIds);
            this.tags(model.tags);
        }

        public final String getReplicationSubnetGroupIdentifier() {
            return this.replicationSubnetGroupIdentifier;
        }

        @Override
        public final Builder replicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier) {
            this.replicationSubnetGroupIdentifier = replicationSubnetGroupIdentifier;
            return this;
        }

        public final void setReplicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier) {
            this.replicationSubnetGroupIdentifier = replicationSubnetGroupIdentifier;
        }

        public final String getReplicationSubnetGroupDescription() {
            return this.replicationSubnetGroupDescription;
        }

        @Override
        public final Builder replicationSubnetGroupDescription(String replicationSubnetGroupDescription) {
            this.replicationSubnetGroupDescription = replicationSubnetGroupDescription;
            return this;
        }

        public final void setReplicationSubnetGroupDescription(String replicationSubnetGroupDescription) {
            this.replicationSubnetGroupDescription = replicationSubnetGroupDescription;
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicationSubnetGroupRequest build() {
            return new CreateReplicationSubnetGroupRequest(this);
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    CopyableBuilder<Builder, CreateReplicationSubnetGroupRequest> {
        public Builder replicationSubnetGroupIdentifier(String var1);

        public Builder replicationSubnetGroupDescription(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

