/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesAsyncClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.ListRecommendersRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListRecommendersResponse;
import software.amazon.awssdk.services.customerprofiles.model.RecommenderSummary;

public class ListRecommendersPublisher
implements SdkPublisher<ListRecommendersResponse> {
    private final CustomerProfilesAsyncClient client;
    private final ListRecommendersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecommendersPublisher(CustomerProfilesAsyncClient client, ListRecommendersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecommendersPublisher(CustomerProfilesAsyncClient client, ListRecommendersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecommendersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecommendersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RecommenderSummary> recommenders() {
        Function<ListRecommendersResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommenders() != null) {
                return response.recommenders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRecommendersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRecommendersResponseFetcher
    implements AsyncPageFetcher<ListRecommendersResponse> {
        private ListRecommendersResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecommendersResponse> nextPage(ListRecommendersResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendersPublisher.this.client.listRecommenders(ListRecommendersPublisher.this.firstRequest);
            }
            return ListRecommendersPublisher.this.client.listRecommenders((ListRecommendersRequest)((Object)ListRecommendersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

