/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.ListRecommenderRecipesRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListRecommenderRecipesResponse;
import software.amazon.awssdk.services.customerprofiles.model.RecommenderRecipe;

public class ListRecommenderRecipesIterable
implements SdkIterable<ListRecommenderRecipesResponse> {
    private final CustomerProfilesClient client;
    private final ListRecommenderRecipesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecommenderRecipesIterable(CustomerProfilesClient client, ListRecommenderRecipesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRecommenderRecipesResponseFetcher();
    }

    public Iterator<ListRecommenderRecipesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecommenderRecipe> recommenderRecipes() {
        Function<ListRecommenderRecipesResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommenderRecipes() != null) {
                return response.recommenderRecipes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRecommenderRecipesResponseFetcher
    implements SyncPageFetcher<ListRecommenderRecipesResponse> {
        private ListRecommenderRecipesResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommenderRecipesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecommenderRecipesResponse nextPage(ListRecommenderRecipesResponse previousPage) {
            if (previousPage == null) {
                return ListRecommenderRecipesIterable.this.client.listRecommenderRecipes(ListRecommenderRecipesIterable.this.firstRequest);
            }
            return ListRecommenderRecipesIterable.this.client.listRecommenderRecipes((ListRecommenderRecipesRequest)((Object)ListRecommenderRecipesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

