/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesAsyncClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.DomainObjectTypesListItem;
import software.amazon.awssdk.services.customerprofiles.model.ListDomainObjectTypesRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListDomainObjectTypesResponse;

public class ListDomainObjectTypesPublisher
implements SdkPublisher<ListDomainObjectTypesResponse> {
    private final CustomerProfilesAsyncClient client;
    private final ListDomainObjectTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDomainObjectTypesPublisher(CustomerProfilesAsyncClient client, ListDomainObjectTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDomainObjectTypesPublisher(CustomerProfilesAsyncClient client, ListDomainObjectTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDomainObjectTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDomainObjectTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DomainObjectTypesListItem> items() {
        Function<ListDomainObjectTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDomainObjectTypesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDomainObjectTypesResponseFetcher
    implements AsyncPageFetcher<ListDomainObjectTypesResponse> {
        private ListDomainObjectTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainObjectTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDomainObjectTypesResponse> nextPage(ListDomainObjectTypesResponse previousPage) {
            if (previousPage == null) {
                return ListDomainObjectTypesPublisher.this.client.listDomainObjectTypes(ListDomainObjectTypesPublisher.this.firstRequest);
            }
            return ListDomainObjectTypesPublisher.this.client.listDomainObjectTypes((ListDomainObjectTypesRequest)((Object)ListDomainObjectTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

