/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.RecommenderConfig;
import software.amazon.awssdk.services.customerprofiles.model.RecommenderRecipeName;
import software.amazon.awssdk.services.customerprofiles.model.RecommenderStatus;
import software.amazon.awssdk.services.customerprofiles.model.RecommenderUpdate;
import software.amazon.awssdk.services.customerprofiles.model.TagMapCopier;
import software.amazon.awssdk.services.customerprofiles.model.TrainingMetrics;
import software.amazon.awssdk.services.customerprofiles.model.TrainingMetricsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRecommenderResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, GetRecommenderResponse> {
    private static final SdkField<String> RECOMMENDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommenderName").getter(GetRecommenderResponse.getter(GetRecommenderResponse::recommenderName)).setter(GetRecommenderResponse.setter(Builder::recommenderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommenderName").build()}).build();
    private static final SdkField<String> RECOMMENDER_RECIPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommenderRecipeName").getter(GetRecommenderResponse.getter(GetRecommenderResponse::recommenderRecipeNameAsString)).setter(GetRecommenderResponse.setter(Builder::recommenderRecipeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommenderRecipeName").build()}).build();
    private static final SdkField<RecommenderConfig> RECOMMENDER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecommenderConfig").getter(GetRecommenderResponse.getter(GetRecommenderResponse::recommenderConfig)).setter(GetRecommenderResponse.setter(Builder::recommenderConfig)).constructor(RecommenderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommenderConfig").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetRecommenderResponse.getter(GetRecommenderResponse::description)).setter(GetRecommenderResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetRecommenderResponse.getter(GetRecommenderResponse::statusAsString)).setter(GetRecommenderResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(GetRecommenderResponse.getter(GetRecommenderResponse::lastUpdatedAt)).setter(GetRecommenderResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetRecommenderResponse.getter(GetRecommenderResponse::createdAt)).setter(GetRecommenderResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(GetRecommenderResponse.getter(GetRecommenderResponse::failureReason)).setter(GetRecommenderResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<RecommenderUpdate> LATEST_RECOMMENDER_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LatestRecommenderUpdate").getter(GetRecommenderResponse.getter(GetRecommenderResponse::latestRecommenderUpdate)).setter(GetRecommenderResponse.setter(Builder::latestRecommenderUpdate)).constructor(RecommenderUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRecommenderUpdate").build()}).build();
    private static final SdkField<List<TrainingMetrics>> TRAINING_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrainingMetrics").getter(GetRecommenderResponse.getter(GetRecommenderResponse::trainingMetrics)).setter(GetRecommenderResponse.setter(Builder::trainingMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrainingMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetRecommenderResponse.getter(GetRecommenderResponse::tags)).setter(GetRecommenderResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDER_NAME_FIELD, RECOMMENDER_RECIPE_NAME_FIELD, RECOMMENDER_CONFIG_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, LAST_UPDATED_AT_FIELD, CREATED_AT_FIELD, FAILURE_REASON_FIELD, LATEST_RECOMMENDER_UPDATE_FIELD, TRAINING_METRICS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRecommenderResponse.memberNameToFieldInitializer();
    private final String recommenderName;
    private final String recommenderRecipeName;
    private final RecommenderConfig recommenderConfig;
    private final String description;
    private final String status;
    private final Instant lastUpdatedAt;
    private final Instant createdAt;
    private final String failureReason;
    private final RecommenderUpdate latestRecommenderUpdate;
    private final List<TrainingMetrics> trainingMetrics;
    private final Map<String, String> tags;

    private GetRecommenderResponse(BuilderImpl builder) {
        super(builder);
        this.recommenderName = builder.recommenderName;
        this.recommenderRecipeName = builder.recommenderRecipeName;
        this.recommenderConfig = builder.recommenderConfig;
        this.description = builder.description;
        this.status = builder.status;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.createdAt = builder.createdAt;
        this.failureReason = builder.failureReason;
        this.latestRecommenderUpdate = builder.latestRecommenderUpdate;
        this.trainingMetrics = builder.trainingMetrics;
        this.tags = builder.tags;
    }

    public final String recommenderName() {
        return this.recommenderName;
    }

    public final RecommenderRecipeName recommenderRecipeName() {
        return RecommenderRecipeName.fromValue(this.recommenderRecipeName);
    }

    public final String recommenderRecipeNameAsString() {
        return this.recommenderRecipeName;
    }

    public final RecommenderConfig recommenderConfig() {
        return this.recommenderConfig;
    }

    public final String description() {
        return this.description;
    }

    public final RecommenderStatus status() {
        return RecommenderStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final RecommenderUpdate latestRecommenderUpdate() {
        return this.latestRecommenderUpdate;
    }

    public final boolean hasTrainingMetrics() {
        return this.trainingMetrics != null && !(this.trainingMetrics instanceof SdkAutoConstructList);
    }

    public final List<TrainingMetrics> trainingMetrics() {
        return this.trainingMetrics;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderRecipeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRecommenderUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrainingMetrics() ? this.trainingMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommenderResponse)) {
            return false;
        }
        GetRecommenderResponse other = (GetRecommenderResponse)((Object)obj);
        return Objects.equals(this.recommenderName(), other.recommenderName()) && Objects.equals(this.recommenderRecipeNameAsString(), other.recommenderRecipeNameAsString()) && Objects.equals(this.recommenderConfig(), other.recommenderConfig()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.latestRecommenderUpdate(), other.latestRecommenderUpdate()) && this.hasTrainingMetrics() == other.hasTrainingMetrics() && Objects.equals(this.trainingMetrics(), other.trainingMetrics()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetRecommenderResponse").add("RecommenderName", (Object)this.recommenderName()).add("RecommenderRecipeName", (Object)this.recommenderRecipeNameAsString()).add("RecommenderConfig", (Object)this.recommenderConfig()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("CreatedAt", (Object)this.createdAt()).add("FailureReason", (Object)this.failureReason()).add("LatestRecommenderUpdate", (Object)this.latestRecommenderUpdate()).add("TrainingMetrics", this.hasTrainingMetrics() ? this.trainingMetrics() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecommenderName": {
                return Optional.ofNullable(clazz.cast(this.recommenderName()));
            }
            case "RecommenderRecipeName": {
                return Optional.ofNullable(clazz.cast(this.recommenderRecipeNameAsString()));
            }
            case "RecommenderConfig": {
                return Optional.ofNullable(clazz.cast(this.recommenderConfig()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "LatestRecommenderUpdate": {
                return Optional.ofNullable(clazz.cast(this.latestRecommenderUpdate()));
            }
            case "TrainingMetrics": {
                return Optional.ofNullable(clazz.cast(this.trainingMetrics()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RecommenderName", RECOMMENDER_NAME_FIELD);
        map.put("RecommenderRecipeName", RECOMMENDER_RECIPE_NAME_FIELD);
        map.put("RecommenderConfig", RECOMMENDER_CONFIG_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("LatestRecommenderUpdate", LATEST_RECOMMENDER_UPDATE_FIELD);
        map.put("TrainingMetrics", TRAINING_METRICS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRecommenderResponse, T> g) {
        return obj -> g.apply((GetRecommenderResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String recommenderName;
        private String recommenderRecipeName;
        private RecommenderConfig recommenderConfig;
        private String description;
        private String status;
        private Instant lastUpdatedAt;
        private Instant createdAt;
        private String failureReason;
        private RecommenderUpdate latestRecommenderUpdate;
        private List<TrainingMetrics> trainingMetrics = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommenderResponse model) {
            super(model);
            this.recommenderName(model.recommenderName);
            this.recommenderRecipeName(model.recommenderRecipeName);
            this.recommenderConfig(model.recommenderConfig);
            this.description(model.description);
            this.status(model.status);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.createdAt(model.createdAt);
            this.failureReason(model.failureReason);
            this.latestRecommenderUpdate(model.latestRecommenderUpdate);
            this.trainingMetrics(model.trainingMetrics);
            this.tags(model.tags);
        }

        public final String getRecommenderName() {
            return this.recommenderName;
        }

        public final void setRecommenderName(String recommenderName) {
            this.recommenderName = recommenderName;
        }

        @Override
        public final Builder recommenderName(String recommenderName) {
            this.recommenderName = recommenderName;
            return this;
        }

        public final String getRecommenderRecipeName() {
            return this.recommenderRecipeName;
        }

        public final void setRecommenderRecipeName(String recommenderRecipeName) {
            this.recommenderRecipeName = recommenderRecipeName;
        }

        @Override
        public final Builder recommenderRecipeName(String recommenderRecipeName) {
            this.recommenderRecipeName = recommenderRecipeName;
            return this;
        }

        @Override
        public final Builder recommenderRecipeName(RecommenderRecipeName recommenderRecipeName) {
            this.recommenderRecipeName(recommenderRecipeName == null ? null : recommenderRecipeName.toString());
            return this;
        }

        public final RecommenderConfig.Builder getRecommenderConfig() {
            return this.recommenderConfig != null ? this.recommenderConfig.toBuilder() : null;
        }

        public final void setRecommenderConfig(RecommenderConfig.BuilderImpl recommenderConfig) {
            this.recommenderConfig = recommenderConfig != null ? recommenderConfig.build() : null;
        }

        @Override
        public final Builder recommenderConfig(RecommenderConfig recommenderConfig) {
            this.recommenderConfig = recommenderConfig;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecommenderStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final RecommenderUpdate.Builder getLatestRecommenderUpdate() {
            return this.latestRecommenderUpdate != null ? this.latestRecommenderUpdate.toBuilder() : null;
        }

        public final void setLatestRecommenderUpdate(RecommenderUpdate.BuilderImpl latestRecommenderUpdate) {
            this.latestRecommenderUpdate = latestRecommenderUpdate != null ? latestRecommenderUpdate.build() : null;
        }

        @Override
        public final Builder latestRecommenderUpdate(RecommenderUpdate latestRecommenderUpdate) {
            this.latestRecommenderUpdate = latestRecommenderUpdate;
            return this;
        }

        public final List<TrainingMetrics.Builder> getTrainingMetrics() {
            List<TrainingMetrics.Builder> result = TrainingMetricsListCopier.copyToBuilder(this.trainingMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrainingMetrics(Collection<TrainingMetrics.BuilderImpl> trainingMetrics) {
            this.trainingMetrics = TrainingMetricsListCopier.copyFromBuilder(trainingMetrics);
        }

        @Override
        public final Builder trainingMetrics(Collection<TrainingMetrics> trainingMetrics) {
            this.trainingMetrics = TrainingMetricsListCopier.copy(trainingMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingMetrics(TrainingMetrics ... trainingMetrics) {
            this.trainingMetrics(Arrays.asList(trainingMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingMetrics(Consumer<TrainingMetrics.Builder> ... trainingMetrics) {
            this.trainingMetrics(Stream.of(trainingMetrics).map(c -> (TrainingMetrics)((TrainingMetrics.Builder)TrainingMetrics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetRecommenderResponse build() {
            return new GetRecommenderResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRecommenderResponse> {
        public Builder recommenderName(String var1);

        public Builder recommenderRecipeName(String var1);

        public Builder recommenderRecipeName(RecommenderRecipeName var1);

        public Builder recommenderConfig(RecommenderConfig var1);

        default public Builder recommenderConfig(Consumer<RecommenderConfig.Builder> recommenderConfig) {
            return this.recommenderConfig((RecommenderConfig)((RecommenderConfig.Builder)RecommenderConfig.builder().applyMutation(recommenderConfig)).build());
        }

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(RecommenderStatus var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder createdAt(Instant var1);

        public Builder failureReason(String var1);

        public Builder latestRecommenderUpdate(RecommenderUpdate var1);

        default public Builder latestRecommenderUpdate(Consumer<RecommenderUpdate.Builder> latestRecommenderUpdate) {
            return this.latestRecommenderUpdate((RecommenderUpdate)((RecommenderUpdate.Builder)RecommenderUpdate.builder().applyMutation(latestRecommenderUpdate)).build());
        }

        public Builder trainingMetrics(Collection<TrainingMetrics> var1);

        public Builder trainingMetrics(TrainingMetrics ... var1);

        public Builder trainingMetrics(Consumer<TrainingMetrics.Builder> ... var1);

        public Builder tags(Map<String, String> var1);
    }
}

