/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.RecommenderContextCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProfileRecommendationsRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, GetProfileRecommendationsRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(GetProfileRecommendationsRequest.getter(GetProfileRecommendationsRequest::domainName)).setter(GetProfileRecommendationsRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileId").getter(GetProfileRecommendationsRequest.getter(GetProfileRecommendationsRequest::profileId)).setter(GetProfileRecommendationsRequest.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ProfileId").build()}).build();
    private static final SdkField<String> RECOMMENDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommenderName").getter(GetProfileRecommendationsRequest.getter(GetProfileRecommendationsRequest::recommenderName)).setter(GetProfileRecommendationsRequest.setter(Builder::recommenderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommenderName").build()}).build();
    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Context").getter(GetProfileRecommendationsRequest.getter(GetProfileRecommendationsRequest::context)).setter(GetProfileRecommendationsRequest.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetProfileRecommendationsRequest.getter(GetProfileRecommendationsRequest::maxResults)).setter(GetProfileRecommendationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, PROFILE_ID_FIELD, RECOMMENDER_NAME_FIELD, CONTEXT_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetProfileRecommendationsRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final String profileId;
    private final String recommenderName;
    private final Map<String, String> context;
    private final Integer maxResults;

    private GetProfileRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.profileId = builder.profileId;
        this.recommenderName = builder.recommenderName;
        this.context = builder.context;
        this.maxResults = builder.maxResults;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final String recommenderName() {
        return this.recommenderName;
    }

    public final boolean hasContext() {
        return this.context != null && !(this.context instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> context() {
        return this.context;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContext() ? this.context() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProfileRecommendationsRequest)) {
            return false;
        }
        GetProfileRecommendationsRequest other = (GetProfileRecommendationsRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.recommenderName(), other.recommenderName()) && this.hasContext() == other.hasContext() && Objects.equals(this.context(), other.context()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetProfileRecommendationsRequest").add("DomainName", (Object)this.domainName()).add("ProfileId", (Object)this.profileId()).add("RecommenderName", (Object)this.recommenderName()).add("Context", (Object)(this.context() == null ? null : "*** Sensitive Data Redacted ***")).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ProfileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "RecommenderName": {
                return Optional.ofNullable(clazz.cast(this.recommenderName()));
            }
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ProfileId", PROFILE_ID_FIELD);
        map.put("RecommenderName", RECOMMENDER_NAME_FIELD);
        map.put("Context", CONTEXT_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetProfileRecommendationsRequest, T> g) {
        return obj -> g.apply((GetProfileRecommendationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String profileId;
        private String recommenderName;
        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProfileRecommendationsRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.profileId(model.profileId);
            this.recommenderName(model.recommenderName);
            this.context(model.context);
            this.maxResults(model.maxResults);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getRecommenderName() {
            return this.recommenderName;
        }

        public final void setRecommenderName(String recommenderName) {
            this.recommenderName = recommenderName;
        }

        @Override
        public final Builder recommenderName(String recommenderName) {
            this.recommenderName = recommenderName;
            return this;
        }

        public final Map<String, String> getContext() {
            if (this.context instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.context;
        }

        public final void setContext(Map<String, String> context) {
            this.context = RecommenderContextCopier.copy(context);
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = RecommenderContextCopier.copy(context);
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetProfileRecommendationsRequest build() {
            return new GetProfileRecommendationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProfileRecommendationsRequest> {
        public Builder domainName(String var1);

        public Builder profileId(String var1);

        public Builder recommenderName(String var1);

        public Builder context(Map<String, String> var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

