/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesAsyncClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.ListUploadJobsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListUploadJobsResponse;
import software.amazon.awssdk.services.customerprofiles.model.UploadJobItem;

public class ListUploadJobsPublisher
implements SdkPublisher<ListUploadJobsResponse> {
    private final CustomerProfilesAsyncClient client;
    private final ListUploadJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUploadJobsPublisher(CustomerProfilesAsyncClient client, ListUploadJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUploadJobsPublisher(CustomerProfilesAsyncClient client, ListUploadJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUploadJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUploadJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UploadJobItem> items() {
        Function<ListUploadJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListUploadJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListUploadJobsResponseFetcher
    implements AsyncPageFetcher<ListUploadJobsResponse> {
        private ListUploadJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListUploadJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUploadJobsResponse> nextPage(ListUploadJobsResponse previousPage) {
            if (previousPage == null) {
                return ListUploadJobsPublisher.this.client.listUploadJobs(ListUploadJobsPublisher.this.firstRequest);
            }
            return ListUploadJobsPublisher.this.client.listUploadJobs((ListUploadJobsRequest)((Object)ListUploadJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

