/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Statistic {
    FIRST_OCCURRENCE("FIRST_OCCURRENCE"),
    LAST_OCCURRENCE("LAST_OCCURRENCE"),
    COUNT("COUNT"),
    SUM("SUM"),
    MINIMUM("MINIMUM"),
    MAXIMUM("MAXIMUM"),
    AVERAGE("AVERAGE"),
    MAX_OCCURRENCE("MAX_OCCURRENCE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Statistic> VALUE_MAP;
    private final String value;

    private Statistic(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Statistic fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Statistic> knownValues() {
        EnumSet<Statistic> knownValues = EnumSet.allOf(Statistic.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Statistic.class, Statistic::toString);
    }
}

