/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SalesforceSourceProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SalesforceSourceProperties> {
    private static final SdkField<String> OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Object").getter(SalesforceSourceProperties.getter(SalesforceSourceProperties::object)).setter(SalesforceSourceProperties.setter(Builder::object)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Object").build()}).build();
    private static final SdkField<Boolean> ENABLE_DYNAMIC_FIELD_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableDynamicFieldUpdate").getter(SalesforceSourceProperties.getter(SalesforceSourceProperties::enableDynamicFieldUpdate)).setter(SalesforceSourceProperties.setter(Builder::enableDynamicFieldUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDynamicFieldUpdate").build()}).build();
    private static final SdkField<Boolean> INCLUDE_DELETED_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeDeletedRecords").getter(SalesforceSourceProperties.getter(SalesforceSourceProperties::includeDeletedRecords)).setter(SalesforceSourceProperties.setter(Builder::includeDeletedRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeDeletedRecords").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_FIELD, ENABLE_DYNAMIC_FIELD_UPDATE_FIELD, INCLUDE_DELETED_RECORDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Object", OBJECT_FIELD);
            this.put("EnableDynamicFieldUpdate", ENABLE_DYNAMIC_FIELD_UPDATE_FIELD);
            this.put("IncludeDeletedRecords", INCLUDE_DELETED_RECORDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String object;
    private final Boolean enableDynamicFieldUpdate;
    private final Boolean includeDeletedRecords;

    private SalesforceSourceProperties(BuilderImpl builder) {
        this.object = builder.object;
        this.enableDynamicFieldUpdate = builder.enableDynamicFieldUpdate;
        this.includeDeletedRecords = builder.includeDeletedRecords;
    }

    public final String object() {
        return this.object;
    }

    public final Boolean enableDynamicFieldUpdate() {
        return this.enableDynamicFieldUpdate;
    }

    public final Boolean includeDeletedRecords() {
        return this.includeDeletedRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.object());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDynamicFieldUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeDeletedRecords());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceSourceProperties)) {
            return false;
        }
        SalesforceSourceProperties other = (SalesforceSourceProperties)obj;
        return Objects.equals(this.object(), other.object()) && Objects.equals(this.enableDynamicFieldUpdate(), other.enableDynamicFieldUpdate()) && Objects.equals(this.includeDeletedRecords(), other.includeDeletedRecords());
    }

    public final String toString() {
        return ToString.builder((String)"SalesforceSourceProperties").add("Object", (Object)this.object()).add("EnableDynamicFieldUpdate", (Object)this.enableDynamicFieldUpdate()).add("IncludeDeletedRecords", (Object)this.includeDeletedRecords()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Object": {
                return Optional.ofNullable(clazz.cast(this.object()));
            }
            case "EnableDynamicFieldUpdate": {
                return Optional.ofNullable(clazz.cast(this.enableDynamicFieldUpdate()));
            }
            case "IncludeDeletedRecords": {
                return Optional.ofNullable(clazz.cast(this.includeDeletedRecords()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SalesforceSourceProperties, T> g) {
        return obj -> g.apply((SalesforceSourceProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String object;
        private Boolean enableDynamicFieldUpdate;
        private Boolean includeDeletedRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceSourceProperties model) {
            this.object(model.object);
            this.enableDynamicFieldUpdate(model.enableDynamicFieldUpdate);
            this.includeDeletedRecords(model.includeDeletedRecords);
        }

        public final String getObject() {
            return this.object;
        }

        public final void setObject(String object) {
            this.object = object;
        }

        @Override
        public final Builder object(String object) {
            this.object = object;
            return this;
        }

        public final Boolean getEnableDynamicFieldUpdate() {
            return this.enableDynamicFieldUpdate;
        }

        public final void setEnableDynamicFieldUpdate(Boolean enableDynamicFieldUpdate) {
            this.enableDynamicFieldUpdate = enableDynamicFieldUpdate;
        }

        @Override
        public final Builder enableDynamicFieldUpdate(Boolean enableDynamicFieldUpdate) {
            this.enableDynamicFieldUpdate = enableDynamicFieldUpdate;
            return this;
        }

        public final Boolean getIncludeDeletedRecords() {
            return this.includeDeletedRecords;
        }

        public final void setIncludeDeletedRecords(Boolean includeDeletedRecords) {
            this.includeDeletedRecords = includeDeletedRecords;
        }

        @Override
        public final Builder includeDeletedRecords(Boolean includeDeletedRecords) {
            this.includeDeletedRecords = includeDeletedRecords;
            return this;
        }

        public SalesforceSourceProperties build() {
            return new SalesforceSourceProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SalesforceSourceProperties> {
        public Builder object(String var1);

        public Builder enableDynamicFieldUpdate(Boolean var1);

        public Builder includeDeletedRecords(Boolean var1);
    }
}

