/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.AttributeTypesSelector;
import software.amazon.awssdk.services.customerprofiles.model.ConflictResolution;
import software.amazon.awssdk.services.customerprofiles.model.ExportingConfig;
import software.amazon.awssdk.services.customerprofiles.model.MatchingRule;
import software.amazon.awssdk.services.customerprofiles.model.MatchingRulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleBasedMatchingRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleBasedMatchingRequest> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(RuleBasedMatchingRequest.getter(RuleBasedMatchingRequest::enabled)).setter(RuleBasedMatchingRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<List<MatchingRule>> MATCHING_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchingRules").getter(RuleBasedMatchingRequest.getter(RuleBasedMatchingRequest::matchingRules)).setter(RuleBasedMatchingRequest.setter(Builder::matchingRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchingRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MatchingRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_ALLOWED_RULE_LEVEL_FOR_MERGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAllowedRuleLevelForMerging").getter(RuleBasedMatchingRequest.getter(RuleBasedMatchingRequest::maxAllowedRuleLevelForMerging)).setter(RuleBasedMatchingRequest.setter(Builder::maxAllowedRuleLevelForMerging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAllowedRuleLevelForMerging").build()}).build();
    private static final SdkField<Integer> MAX_ALLOWED_RULE_LEVEL_FOR_MATCHING_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAllowedRuleLevelForMatching").getter(RuleBasedMatchingRequest.getter(RuleBasedMatchingRequest::maxAllowedRuleLevelForMatching)).setter(RuleBasedMatchingRequest.setter(Builder::maxAllowedRuleLevelForMatching)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAllowedRuleLevelForMatching").build()}).build();
    private static final SdkField<AttributeTypesSelector> ATTRIBUTE_TYPES_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttributeTypesSelector").getter(RuleBasedMatchingRequest.getter(RuleBasedMatchingRequest::attributeTypesSelector)).setter(RuleBasedMatchingRequest.setter(Builder::attributeTypesSelector)).constructor(AttributeTypesSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeTypesSelector").build()}).build();
    private static final SdkField<ConflictResolution> CONFLICT_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConflictResolution").getter(RuleBasedMatchingRequest.getter(RuleBasedMatchingRequest::conflictResolution)).setter(RuleBasedMatchingRequest.setter(Builder::conflictResolution)).constructor(ConflictResolution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConflictResolution").build()}).build();
    private static final SdkField<ExportingConfig> EXPORTING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportingConfig").getter(RuleBasedMatchingRequest.getter(RuleBasedMatchingRequest::exportingConfig)).setter(RuleBasedMatchingRequest.setter(Builder::exportingConfig)).constructor(ExportingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportingConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, MATCHING_RULES_FIELD, MAX_ALLOWED_RULE_LEVEL_FOR_MERGING_FIELD, MAX_ALLOWED_RULE_LEVEL_FOR_MATCHING_FIELD, ATTRIBUTE_TYPES_SELECTOR_FIELD, CONFLICT_RESOLUTION_FIELD, EXPORTING_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final List<MatchingRule> matchingRules;
    private final Integer maxAllowedRuleLevelForMerging;
    private final Integer maxAllowedRuleLevelForMatching;
    private final AttributeTypesSelector attributeTypesSelector;
    private final ConflictResolution conflictResolution;
    private final ExportingConfig exportingConfig;

    private RuleBasedMatchingRequest(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.matchingRules = builder.matchingRules;
        this.maxAllowedRuleLevelForMerging = builder.maxAllowedRuleLevelForMerging;
        this.maxAllowedRuleLevelForMatching = builder.maxAllowedRuleLevelForMatching;
        this.attributeTypesSelector = builder.attributeTypesSelector;
        this.conflictResolution = builder.conflictResolution;
        this.exportingConfig = builder.exportingConfig;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final boolean hasMatchingRules() {
        return this.matchingRules != null && !(this.matchingRules instanceof SdkAutoConstructList);
    }

    public final List<MatchingRule> matchingRules() {
        return this.matchingRules;
    }

    public final Integer maxAllowedRuleLevelForMerging() {
        return this.maxAllowedRuleLevelForMerging;
    }

    public final Integer maxAllowedRuleLevelForMatching() {
        return this.maxAllowedRuleLevelForMatching;
    }

    public final AttributeTypesSelector attributeTypesSelector() {
        return this.attributeTypesSelector;
    }

    public final ConflictResolution conflictResolution() {
        return this.conflictResolution;
    }

    public final ExportingConfig exportingConfig() {
        return this.exportingConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchingRules() ? this.matchingRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAllowedRuleLevelForMerging());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAllowedRuleLevelForMatching());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeTypesSelector());
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictResolution());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportingConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleBasedMatchingRequest)) {
            return false;
        }
        RuleBasedMatchingRequest other = (RuleBasedMatchingRequest)obj;
        return Objects.equals(this.enabled(), other.enabled()) && this.hasMatchingRules() == other.hasMatchingRules() && Objects.equals(this.matchingRules(), other.matchingRules()) && Objects.equals(this.maxAllowedRuleLevelForMerging(), other.maxAllowedRuleLevelForMerging()) && Objects.equals(this.maxAllowedRuleLevelForMatching(), other.maxAllowedRuleLevelForMatching()) && Objects.equals(this.attributeTypesSelector(), other.attributeTypesSelector()) && Objects.equals(this.conflictResolution(), other.conflictResolution()) && Objects.equals(this.exportingConfig(), other.exportingConfig());
    }

    public final String toString() {
        return ToString.builder((String)"RuleBasedMatchingRequest").add("Enabled", (Object)this.enabled()).add("MatchingRules", this.hasMatchingRules() ? this.matchingRules() : null).add("MaxAllowedRuleLevelForMerging", (Object)this.maxAllowedRuleLevelForMerging()).add("MaxAllowedRuleLevelForMatching", (Object)this.maxAllowedRuleLevelForMatching()).add("AttributeTypesSelector", (Object)this.attributeTypesSelector()).add("ConflictResolution", (Object)this.conflictResolution()).add("ExportingConfig", (Object)this.exportingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "MatchingRules": {
                return Optional.ofNullable(clazz.cast(this.matchingRules()));
            }
            case "MaxAllowedRuleLevelForMerging": {
                return Optional.ofNullable(clazz.cast(this.maxAllowedRuleLevelForMerging()));
            }
            case "MaxAllowedRuleLevelForMatching": {
                return Optional.ofNullable(clazz.cast(this.maxAllowedRuleLevelForMatching()));
            }
            case "AttributeTypesSelector": {
                return Optional.ofNullable(clazz.cast(this.attributeTypesSelector()));
            }
            case "ConflictResolution": {
                return Optional.ofNullable(clazz.cast(this.conflictResolution()));
            }
            case "ExportingConfig": {
                return Optional.ofNullable(clazz.cast(this.exportingConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleBasedMatchingRequest, T> g) {
        return obj -> g.apply((RuleBasedMatchingRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private List<MatchingRule> matchingRules = DefaultSdkAutoConstructList.getInstance();
        private Integer maxAllowedRuleLevelForMerging;
        private Integer maxAllowedRuleLevelForMatching;
        private AttributeTypesSelector attributeTypesSelector;
        private ConflictResolution conflictResolution;
        private ExportingConfig exportingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleBasedMatchingRequest model) {
            this.enabled(model.enabled);
            this.matchingRules(model.matchingRules);
            this.maxAllowedRuleLevelForMerging(model.maxAllowedRuleLevelForMerging);
            this.maxAllowedRuleLevelForMatching(model.maxAllowedRuleLevelForMatching);
            this.attributeTypesSelector(model.attributeTypesSelector);
            this.conflictResolution(model.conflictResolution);
            this.exportingConfig(model.exportingConfig);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final List<MatchingRule.Builder> getMatchingRules() {
            List<MatchingRule.Builder> result = MatchingRulesCopier.copyToBuilder(this.matchingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchingRules(Collection<MatchingRule.BuilderImpl> matchingRules) {
            this.matchingRules = MatchingRulesCopier.copyFromBuilder(matchingRules);
        }

        @Override
        public final Builder matchingRules(Collection<MatchingRule> matchingRules) {
            this.matchingRules = MatchingRulesCopier.copy(matchingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingRules(MatchingRule ... matchingRules) {
            this.matchingRules(Arrays.asList(matchingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingRules(Consumer<MatchingRule.Builder> ... matchingRules) {
            this.matchingRules(Stream.of(matchingRules).map(c -> (MatchingRule)((MatchingRule.Builder)MatchingRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxAllowedRuleLevelForMerging() {
            return this.maxAllowedRuleLevelForMerging;
        }

        public final void setMaxAllowedRuleLevelForMerging(Integer maxAllowedRuleLevelForMerging) {
            this.maxAllowedRuleLevelForMerging = maxAllowedRuleLevelForMerging;
        }

        @Override
        public final Builder maxAllowedRuleLevelForMerging(Integer maxAllowedRuleLevelForMerging) {
            this.maxAllowedRuleLevelForMerging = maxAllowedRuleLevelForMerging;
            return this;
        }

        public final Integer getMaxAllowedRuleLevelForMatching() {
            return this.maxAllowedRuleLevelForMatching;
        }

        public final void setMaxAllowedRuleLevelForMatching(Integer maxAllowedRuleLevelForMatching) {
            this.maxAllowedRuleLevelForMatching = maxAllowedRuleLevelForMatching;
        }

        @Override
        public final Builder maxAllowedRuleLevelForMatching(Integer maxAllowedRuleLevelForMatching) {
            this.maxAllowedRuleLevelForMatching = maxAllowedRuleLevelForMatching;
            return this;
        }

        public final AttributeTypesSelector.Builder getAttributeTypesSelector() {
            return this.attributeTypesSelector != null ? this.attributeTypesSelector.toBuilder() : null;
        }

        public final void setAttributeTypesSelector(AttributeTypesSelector.BuilderImpl attributeTypesSelector) {
            this.attributeTypesSelector = attributeTypesSelector != null ? attributeTypesSelector.build() : null;
        }

        @Override
        public final Builder attributeTypesSelector(AttributeTypesSelector attributeTypesSelector) {
            this.attributeTypesSelector = attributeTypesSelector;
            return this;
        }

        public final ConflictResolution.Builder getConflictResolution() {
            return this.conflictResolution != null ? this.conflictResolution.toBuilder() : null;
        }

        public final void setConflictResolution(ConflictResolution.BuilderImpl conflictResolution) {
            this.conflictResolution = conflictResolution != null ? conflictResolution.build() : null;
        }

        @Override
        public final Builder conflictResolution(ConflictResolution conflictResolution) {
            this.conflictResolution = conflictResolution;
            return this;
        }

        public final ExportingConfig.Builder getExportingConfig() {
            return this.exportingConfig != null ? this.exportingConfig.toBuilder() : null;
        }

        public final void setExportingConfig(ExportingConfig.BuilderImpl exportingConfig) {
            this.exportingConfig = exportingConfig != null ? exportingConfig.build() : null;
        }

        @Override
        public final Builder exportingConfig(ExportingConfig exportingConfig) {
            this.exportingConfig = exportingConfig;
            return this;
        }

        public RuleBasedMatchingRequest build() {
            return new RuleBasedMatchingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleBasedMatchingRequest> {
        public Builder enabled(Boolean var1);

        public Builder matchingRules(Collection<MatchingRule> var1);

        public Builder matchingRules(MatchingRule ... var1);

        public Builder matchingRules(Consumer<MatchingRule.Builder> ... var1);

        public Builder maxAllowedRuleLevelForMerging(Integer var1);

        public Builder maxAllowedRuleLevelForMatching(Integer var1);

        public Builder attributeTypesSelector(AttributeTypesSelector var1);

        default public Builder attributeTypesSelector(Consumer<AttributeTypesSelector.Builder> attributeTypesSelector) {
            return this.attributeTypesSelector((AttributeTypesSelector)((AttributeTypesSelector.Builder)AttributeTypesSelector.builder().applyMutation(attributeTypesSelector)).build());
        }

        public Builder conflictResolution(ConflictResolution var1);

        default public Builder conflictResolution(Consumer<ConflictResolution.Builder> conflictResolution) {
            return this.conflictResolution((ConflictResolution)((ConflictResolution.Builder)ConflictResolution.builder().applyMutation(conflictResolution)).build());
        }

        public Builder exportingConfig(ExportingConfig var1);

        default public Builder exportingConfig(Consumer<ExportingConfig.Builder> exportingConfig) {
            return this.exportingConfig((ExportingConfig)((ExportingConfig.Builder)ExportingConfig.builder().applyMutation(exportingConfig)).build());
        }
    }
}

