/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteProfileObjectRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, DeleteProfileObjectRequest> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileId").getter(DeleteProfileObjectRequest.getter(DeleteProfileObjectRequest::profileId)).setter(DeleteProfileObjectRequest.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()}).build();
    private static final SdkField<String> PROFILE_OBJECT_UNIQUE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileObjectUniqueKey").getter(DeleteProfileObjectRequest.getter(DeleteProfileObjectRequest::profileObjectUniqueKey)).setter(DeleteProfileObjectRequest.setter(Builder::profileObjectUniqueKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileObjectUniqueKey").build()}).build();
    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectTypeName").getter(DeleteProfileObjectRequest.getter(DeleteProfileObjectRequest::objectTypeName)).setter(DeleteProfileObjectRequest.setter(Builder::objectTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeName").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DeleteProfileObjectRequest.getter(DeleteProfileObjectRequest::domainName)).setter(DeleteProfileObjectRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD, PROFILE_OBJECT_UNIQUE_KEY_FIELD, OBJECT_TYPE_NAME_FIELD, DOMAIN_NAME_FIELD));
    private final String profileId;
    private final String profileObjectUniqueKey;
    private final String objectTypeName;
    private final String domainName;

    private DeleteProfileObjectRequest(BuilderImpl builder) {
        super(builder);
        this.profileId = builder.profileId;
        this.profileObjectUniqueKey = builder.profileObjectUniqueKey;
        this.objectTypeName = builder.objectTypeName;
        this.domainName = builder.domainName;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final String profileObjectUniqueKey() {
        return this.profileObjectUniqueKey;
    }

    public final String objectTypeName() {
        return this.objectTypeName;
    }

    public final String domainName() {
        return this.domainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileObjectUniqueKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProfileObjectRequest)) {
            return false;
        }
        DeleteProfileObjectRequest other = (DeleteProfileObjectRequest)((Object)obj);
        return Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.profileObjectUniqueKey(), other.profileObjectUniqueKey()) && Objects.equals(this.objectTypeName(), other.objectTypeName()) && Objects.equals(this.domainName(), other.domainName());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteProfileObjectRequest").add("ProfileId", (Object)this.profileId()).add("ProfileObjectUniqueKey", (Object)this.profileObjectUniqueKey()).add("ObjectTypeName", (Object)this.objectTypeName()).add("DomainName", (Object)this.domainName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "ProfileObjectUniqueKey": {
                return Optional.ofNullable(clazz.cast(this.profileObjectUniqueKey()));
            }
            case "ObjectTypeName": {
                return Optional.ofNullable(clazz.cast(this.objectTypeName()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteProfileObjectRequest, T> g) {
        return obj -> g.apply((DeleteProfileObjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String profileId;
        private String profileObjectUniqueKey;
        private String objectTypeName;
        private String domainName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProfileObjectRequest model) {
            super(model);
            this.profileId(model.profileId);
            this.profileObjectUniqueKey(model.profileObjectUniqueKey);
            this.objectTypeName(model.objectTypeName);
            this.domainName(model.domainName);
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getProfileObjectUniqueKey() {
            return this.profileObjectUniqueKey;
        }

        public final void setProfileObjectUniqueKey(String profileObjectUniqueKey) {
            this.profileObjectUniqueKey = profileObjectUniqueKey;
        }

        @Override
        public final Builder profileObjectUniqueKey(String profileObjectUniqueKey) {
            this.profileObjectUniqueKey = profileObjectUniqueKey;
            return this;
        }

        public final String getObjectTypeName() {
            return this.objectTypeName;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteProfileObjectRequest build() {
            return new DeleteProfileObjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteProfileObjectRequest> {
        public Builder profileId(String var1);

        public Builder profileObjectUniqueKey(String var1);

        public Builder objectTypeName(String var1);

        public Builder domainName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

