/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Workflow step details for <code>APPFLOW_INTEGRATION</code> workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppflowIntegrationWorkflowStep implements SdkPojo, Serializable,
        ToCopyableBuilder<AppflowIntegrationWorkflowStep.Builder, AppflowIntegrationWorkflowStep> {
    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowName").getter(getter(AppflowIntegrationWorkflowStep::flowName)).setter(setter(Builder::flowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AppflowIntegrationWorkflowStep::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> EXECUTION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionMessage").getter(getter(AppflowIntegrationWorkflowStep::executionMessage))
            .setter(setter(Builder::executionMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionMessage").build()).build();

    private static final SdkField<Long> RECORDS_PROCESSED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RecordsProcessed").getter(getter(AppflowIntegrationWorkflowStep::recordsProcessed))
            .setter(setter(Builder::recordsProcessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordsProcessed").build()).build();

    private static final SdkField<String> BATCH_RECORDS_START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BatchRecordsStartTime").getter(getter(AppflowIntegrationWorkflowStep::batchRecordsStartTime))
            .setter(setter(Builder::batchRecordsStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchRecordsStartTime").build())
            .build();

    private static final SdkField<String> BATCH_RECORDS_END_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BatchRecordsEndTime").getter(getter(AppflowIntegrationWorkflowStep::batchRecordsEndTime))
            .setter(setter(Builder::batchRecordsEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchRecordsEndTime").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(AppflowIntegrationWorkflowStep::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(AppflowIntegrationWorkflowStep::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_NAME_FIELD, STATUS_FIELD,
            EXECUTION_MESSAGE_FIELD, RECORDS_PROCESSED_FIELD, BATCH_RECORDS_START_TIME_FIELD, BATCH_RECORDS_END_TIME_FIELD,
            CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String flowName;

    private final String status;

    private final String executionMessage;

    private final Long recordsProcessed;

    private final String batchRecordsStartTime;

    private final String batchRecordsEndTime;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private AppflowIntegrationWorkflowStep(BuilderImpl builder) {
        this.flowName = builder.flowName;
        this.status = builder.status;
        this.executionMessage = builder.executionMessage;
        this.recordsProcessed = builder.recordsProcessed;
        this.batchRecordsStartTime = builder.batchRecordsStartTime;
        this.batchRecordsEndTime = builder.batchRecordsEndTime;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * Name of the flow created during execution of workflow step. <code>APPFLOW_INTEGRATION</code> workflow type
     * creates an appflow flow during workflow step execution on the customers behalf.
     * </p>
     * 
     * @return Name of the flow created during execution of workflow step. <code>APPFLOW_INTEGRATION</code> workflow
     *         type creates an appflow flow during workflow step execution on the customers behalf.
     */
    public final String flowName() {
        return flowName;
    }

    /**
     * <p>
     * Workflow step status for <code>APPFLOW_INTEGRATION</code> workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Workflow step status for <code>APPFLOW_INTEGRATION</code> workflow.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * Workflow step status for <code>APPFLOW_INTEGRATION</code> workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Workflow step status for <code>APPFLOW_INTEGRATION</code> workflow.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Message indicating execution of workflow step for <code>APPFLOW_INTEGRATION</code> workflow.
     * </p>
     * 
     * @return Message indicating execution of workflow step for <code>APPFLOW_INTEGRATION</code> workflow.
     */
    public final String executionMessage() {
        return executionMessage;
    }

    /**
     * <p>
     * Total number of records processed during execution of workflow step for <code>APPFLOW_INTEGRATION</code>
     * workflow.
     * </p>
     * 
     * @return Total number of records processed during execution of workflow step for <code>APPFLOW_INTEGRATION</code>
     *         workflow.
     */
    public final Long recordsProcessed() {
        return recordsProcessed;
    }

    /**
     * <p>
     * Start datetime of records pulled in batch during execution of workflow step for <code>APPFLOW_INTEGRATION</code>
     * workflow.
     * </p>
     * 
     * @return Start datetime of records pulled in batch during execution of workflow step for
     *         <code>APPFLOW_INTEGRATION</code> workflow.
     */
    public final String batchRecordsStartTime() {
        return batchRecordsStartTime;
    }

    /**
     * <p>
     * End datetime of records pulled in batch during execution of workflow step for <code>APPFLOW_INTEGRATION</code>
     * workflow.
     * </p>
     * 
     * @return End datetime of records pulled in batch during execution of workflow step for
     *         <code>APPFLOW_INTEGRATION</code> workflow.
     */
    public final String batchRecordsEndTime() {
        return batchRecordsEndTime;
    }

    /**
     * <p>
     * Creation timestamp of workflow step for <code>APPFLOW_INTEGRATION</code> workflow.
     * </p>
     * 
     * @return Creation timestamp of workflow step for <code>APPFLOW_INTEGRATION</code> workflow.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Last updated timestamp for workflow step for <code>APPFLOW_INTEGRATION</code> workflow.
     * </p>
     * 
     * @return Last updated timestamp for workflow step for <code>APPFLOW_INTEGRATION</code> workflow.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executionMessage());
        hashCode = 31 * hashCode + Objects.hashCode(recordsProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(batchRecordsStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(batchRecordsEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppflowIntegrationWorkflowStep)) {
            return false;
        }
        AppflowIntegrationWorkflowStep other = (AppflowIntegrationWorkflowStep) obj;
        return Objects.equals(flowName(), other.flowName()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(executionMessage(), other.executionMessage())
                && Objects.equals(recordsProcessed(), other.recordsProcessed())
                && Objects.equals(batchRecordsStartTime(), other.batchRecordsStartTime())
                && Objects.equals(batchRecordsEndTime(), other.batchRecordsEndTime())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppflowIntegrationWorkflowStep").add("FlowName", flowName()).add("Status", statusAsString())
                .add("ExecutionMessage", executionMessage()).add("RecordsProcessed", recordsProcessed())
                .add("BatchRecordsStartTime", batchRecordsStartTime()).add("BatchRecordsEndTime", batchRecordsEndTime())
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowName":
            return Optional.ofNullable(clazz.cast(flowName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ExecutionMessage":
            return Optional.ofNullable(clazz.cast(executionMessage()));
        case "RecordsProcessed":
            return Optional.ofNullable(clazz.cast(recordsProcessed()));
        case "BatchRecordsStartTime":
            return Optional.ofNullable(clazz.cast(batchRecordsStartTime()));
        case "BatchRecordsEndTime":
            return Optional.ofNullable(clazz.cast(batchRecordsEndTime()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppflowIntegrationWorkflowStep, T> g) {
        return obj -> g.apply((AppflowIntegrationWorkflowStep) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppflowIntegrationWorkflowStep> {
        /**
         * <p>
         * Name of the flow created during execution of workflow step. <code>APPFLOW_INTEGRATION</code> workflow type
         * creates an appflow flow during workflow step execution on the customers behalf.
         * </p>
         * 
         * @param flowName
         *        Name of the flow created during execution of workflow step. <code>APPFLOW_INTEGRATION</code> workflow
         *        type creates an appflow flow during workflow step execution on the customers behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowName(String flowName);

        /**
         * <p>
         * Workflow step status for <code>APPFLOW_INTEGRATION</code> workflow.
         * </p>
         * 
         * @param status
         *        Workflow step status for <code>APPFLOW_INTEGRATION</code> workflow.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * Workflow step status for <code>APPFLOW_INTEGRATION</code> workflow.
         * </p>
         * 
         * @param status
         *        Workflow step status for <code>APPFLOW_INTEGRATION</code> workflow.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * Message indicating execution of workflow step for <code>APPFLOW_INTEGRATION</code> workflow.
         * </p>
         * 
         * @param executionMessage
         *        Message indicating execution of workflow step for <code>APPFLOW_INTEGRATION</code> workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionMessage(String executionMessage);

        /**
         * <p>
         * Total number of records processed during execution of workflow step for <code>APPFLOW_INTEGRATION</code>
         * workflow.
         * </p>
         * 
         * @param recordsProcessed
         *        Total number of records processed during execution of workflow step for
         *        <code>APPFLOW_INTEGRATION</code> workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordsProcessed(Long recordsProcessed);

        /**
         * <p>
         * Start datetime of records pulled in batch during execution of workflow step for
         * <code>APPFLOW_INTEGRATION</code> workflow.
         * </p>
         * 
         * @param batchRecordsStartTime
         *        Start datetime of records pulled in batch during execution of workflow step for
         *        <code>APPFLOW_INTEGRATION</code> workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchRecordsStartTime(String batchRecordsStartTime);

        /**
         * <p>
         * End datetime of records pulled in batch during execution of workflow step for
         * <code>APPFLOW_INTEGRATION</code> workflow.
         * </p>
         * 
         * @param batchRecordsEndTime
         *        End datetime of records pulled in batch during execution of workflow step for
         *        <code>APPFLOW_INTEGRATION</code> workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchRecordsEndTime(String batchRecordsEndTime);

        /**
         * <p>
         * Creation timestamp of workflow step for <code>APPFLOW_INTEGRATION</code> workflow.
         * </p>
         * 
         * @param createdAt
         *        Creation timestamp of workflow step for <code>APPFLOW_INTEGRATION</code> workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Last updated timestamp for workflow step for <code>APPFLOW_INTEGRATION</code> workflow.
         * </p>
         * 
         * @param lastUpdatedAt
         *        Last updated timestamp for workflow step for <code>APPFLOW_INTEGRATION</code> workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String flowName;

        private String status;

        private String executionMessage;

        private Long recordsProcessed;

        private String batchRecordsStartTime;

        private String batchRecordsEndTime;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AppflowIntegrationWorkflowStep model) {
            flowName(model.flowName);
            status(model.status);
            executionMessage(model.executionMessage);
            recordsProcessed(model.recordsProcessed);
            batchRecordsStartTime(model.batchRecordsStartTime);
            batchRecordsEndTime(model.batchRecordsEndTime);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getFlowName() {
            return flowName;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        @Override
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getExecutionMessage() {
            return executionMessage;
        }

        public final void setExecutionMessage(String executionMessage) {
            this.executionMessage = executionMessage;
        }

        @Override
        public final Builder executionMessage(String executionMessage) {
            this.executionMessage = executionMessage;
            return this;
        }

        public final Long getRecordsProcessed() {
            return recordsProcessed;
        }

        public final void setRecordsProcessed(Long recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
        }

        @Override
        public final Builder recordsProcessed(Long recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
            return this;
        }

        public final String getBatchRecordsStartTime() {
            return batchRecordsStartTime;
        }

        public final void setBatchRecordsStartTime(String batchRecordsStartTime) {
            this.batchRecordsStartTime = batchRecordsStartTime;
        }

        @Override
        public final Builder batchRecordsStartTime(String batchRecordsStartTime) {
            this.batchRecordsStartTime = batchRecordsStartTime;
            return this;
        }

        public final String getBatchRecordsEndTime() {
            return batchRecordsEndTime;
        }

        public final void setBatchRecordsEndTime(String batchRecordsEndTime) {
            this.batchRecordsEndTime = batchRecordsEndTime;
        }

        @Override
        public final Builder batchRecordsEndTime(String batchRecordsEndTime) {
            this.batchRecordsEndTime = batchRecordsEndTime;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public AppflowIntegrationWorkflowStep build() {
            return new AppflowIntegrationWorkflowStep(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
