/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Workflow specific execution metrics for <code>APPFLOW_INTEGRATION</code> workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppflowIntegrationWorkflowMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<AppflowIntegrationWorkflowMetrics.Builder, AppflowIntegrationWorkflowMetrics> {
    private static final SdkField<Long> RECORDS_PROCESSED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RecordsProcessed").getter(getter(AppflowIntegrationWorkflowMetrics::recordsProcessed))
            .setter(setter(Builder::recordsProcessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordsProcessed").build()).build();

    private static final SdkField<Long> STEPS_COMPLETED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("StepsCompleted").getter(getter(AppflowIntegrationWorkflowMetrics::stepsCompleted))
            .setter(setter(Builder::stepsCompleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepsCompleted").build()).build();

    private static final SdkField<Long> TOTAL_STEPS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalSteps").getter(getter(AppflowIntegrationWorkflowMetrics::totalSteps))
            .setter(setter(Builder::totalSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSteps").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_PROCESSED_FIELD,
            STEPS_COMPLETED_FIELD, TOTAL_STEPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long recordsProcessed;

    private final Long stepsCompleted;

    private final Long totalSteps;

    private AppflowIntegrationWorkflowMetrics(BuilderImpl builder) {
        this.recordsProcessed = builder.recordsProcessed;
        this.stepsCompleted = builder.stepsCompleted;
        this.totalSteps = builder.totalSteps;
    }

    /**
     * <p>
     * Number of records processed in <code>APPFLOW_INTEGRATION</code> workflow.
     * </p>
     * 
     * @return Number of records processed in <code>APPFLOW_INTEGRATION</code> workflow.
     */
    public final Long recordsProcessed() {
        return recordsProcessed;
    }

    /**
     * <p>
     * Total steps completed in <code>APPFLOW_INTEGRATION</code> workflow.
     * </p>
     * 
     * @return Total steps completed in <code>APPFLOW_INTEGRATION</code> workflow.
     */
    public final Long stepsCompleted() {
        return stepsCompleted;
    }

    /**
     * <p>
     * Total steps in <code>APPFLOW_INTEGRATION</code> workflow.
     * </p>
     * 
     * @return Total steps in <code>APPFLOW_INTEGRATION</code> workflow.
     */
    public final Long totalSteps() {
        return totalSteps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordsProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(stepsCompleted());
        hashCode = 31 * hashCode + Objects.hashCode(totalSteps());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppflowIntegrationWorkflowMetrics)) {
            return false;
        }
        AppflowIntegrationWorkflowMetrics other = (AppflowIntegrationWorkflowMetrics) obj;
        return Objects.equals(recordsProcessed(), other.recordsProcessed())
                && Objects.equals(stepsCompleted(), other.stepsCompleted()) && Objects.equals(totalSteps(), other.totalSteps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppflowIntegrationWorkflowMetrics").add("RecordsProcessed", recordsProcessed())
                .add("StepsCompleted", stepsCompleted()).add("TotalSteps", totalSteps()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordsProcessed":
            return Optional.ofNullable(clazz.cast(recordsProcessed()));
        case "StepsCompleted":
            return Optional.ofNullable(clazz.cast(stepsCompleted()));
        case "TotalSteps":
            return Optional.ofNullable(clazz.cast(totalSteps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppflowIntegrationWorkflowMetrics, T> g) {
        return obj -> g.apply((AppflowIntegrationWorkflowMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppflowIntegrationWorkflowMetrics> {
        /**
         * <p>
         * Number of records processed in <code>APPFLOW_INTEGRATION</code> workflow.
         * </p>
         * 
         * @param recordsProcessed
         *        Number of records processed in <code>APPFLOW_INTEGRATION</code> workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordsProcessed(Long recordsProcessed);

        /**
         * <p>
         * Total steps completed in <code>APPFLOW_INTEGRATION</code> workflow.
         * </p>
         * 
         * @param stepsCompleted
         *        Total steps completed in <code>APPFLOW_INTEGRATION</code> workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepsCompleted(Long stepsCompleted);

        /**
         * <p>
         * Total steps in <code>APPFLOW_INTEGRATION</code> workflow.
         * </p>
         * 
         * @param totalSteps
         *        Total steps in <code>APPFLOW_INTEGRATION</code> workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalSteps(Long totalSteps);
    }

    static final class BuilderImpl implements Builder {
        private Long recordsProcessed;

        private Long stepsCompleted;

        private Long totalSteps;

        private BuilderImpl() {
        }

        private BuilderImpl(AppflowIntegrationWorkflowMetrics model) {
            recordsProcessed(model.recordsProcessed);
            stepsCompleted(model.stepsCompleted);
            totalSteps(model.totalSteps);
        }

        public final Long getRecordsProcessed() {
            return recordsProcessed;
        }

        public final void setRecordsProcessed(Long recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
        }

        @Override
        public final Builder recordsProcessed(Long recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
            return this;
        }

        public final Long getStepsCompleted() {
            return stepsCompleted;
        }

        public final void setStepsCompleted(Long stepsCompleted) {
            this.stepsCompleted = stepsCompleted;
        }

        @Override
        public final Builder stepsCompleted(Long stepsCompleted) {
            this.stepsCompleted = stepsCompleted;
            return this;
        }

        public final Long getTotalSteps() {
            return totalSteps;
        }

        public final void setTotalSteps(Long totalSteps) {
            this.totalSteps = totalSteps;
        }

        @Override
        public final Builder totalSteps(Long totalSteps) {
            this.totalSteps = totalSteps;
            return this;
        }

        @Override
        public AppflowIntegrationWorkflowMetrics build() {
            return new AppflowIntegrationWorkflowMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
