/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FieldContentType {
    STRING("STRING"),
    NUMBER("NUMBER"),
    PHONE_NUMBER("PHONE_NUMBER"),
    EMAIL_ADDRESS("EMAIL_ADDRESS"),
    NAME("NAME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FieldContentType> VALUE_MAP;
    private final String value;

    private FieldContentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FieldContentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FieldContentType> knownValues() {
        EnumSet<FieldContentType> knownValues = EnumSet.allOf(FieldContentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FieldContentType.class, FieldContentType::toString);
    }
}

