/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import software.amazon.awssdk.crt.CRT;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.HttpClientConnectionManager;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.crt.http.HttpStream;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandler;

public class HttpClientConnection
extends CrtResource {
    private final HttpClientConnectionManager manager;

    protected HttpClientConnection(HttpClientConnectionManager manager, long connection) {
        this.acquireNativeHandle(connection);
        this.addReferenceTo(manager);
        this.manager = manager;
    }

    public HttpStream makeRequest(HttpRequest request, HttpStreamResponseHandler streamHandler) throws CrtRuntimeException {
        if (this.isNull()) {
            throw new IllegalStateException("HttpClientConnection has been closed, can't make requests on it.");
        }
        HttpStream stream = HttpClientConnection.httpClientConnectionMakeRequest(this.getNativeHandle(), request.getMethod(), request.getEncodedPath(), request.getHeadersAsArray(), request.getBodyStream(), streamHandler);
        if (stream == null || stream.isNull()) {
            throw new CrtRuntimeException(CRT.awsLastError(), "HttpStream   creation failed");
        }
        return stream;
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            this.manager.releaseConnectionPointer(this.getNativeHandle());
        }
    }

    private static native HttpStream httpClientConnectionMakeRequest(long var0, String var2, String var3, HttpHeader[] var4, HttpRequestBodyStream var5, HttpStreamResponseHandler var6) throws CrtRuntimeException;
}

