/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.auth.signing;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.auth.credentials.CredentialsProvider;

public class AwsSigningConfig
extends CrtResource {
    private int signingAlgorithm = AwsSigningAlgorithm.SIGV4_HEADER.getNativeValue();
    private String region;
    private String service;
    private long time = System.currentTimeMillis();
    private CredentialsProvider credentialsProvider;
    private Predicate<String> shouldSignParameter;
    private boolean useDoubleUriEncode = true;
    private boolean shouldNormalizeUriPath = true;
    private int signBody = AwsBodySigningConfigType.AWS_BODY_SIGNING_OFF.getNativeValue();

    public AwsSigningConfig clone() {
        try (AwsSigningConfig clone = new AwsSigningConfig();){
            clone.setSigningAlgorithm(this.getSigningAlgorithm());
            clone.setRegion(this.getRegion());
            clone.setService(this.getService());
            clone.setTime(this.getTime());
            clone.setCredentialsProvider(this.getCredentialsProvider());
            clone.setShouldSignParameter(this.getShouldSignParameter());
            clone.setUseDoubleUriEncode(this.getUseDoubleUriEncode());
            clone.setShouldNormalizeUriPath(this.getShouldNormalizeUriPath());
            clone.setSignBody(this.getSignBody());
            clone.addRef();
            AwsSigningConfig awsSigningConfig = clone;
            return awsSigningConfig;
        }
    }

    @Override
    protected void releaseNativeHandle() {
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    public void setSigningAlgorithm(AwsSigningAlgorithm algorithm) {
        this.signingAlgorithm = algorithm.getNativeValue();
    }

    public AwsSigningAlgorithm getSigningAlgorithm() {
        return AwsSigningAlgorithm.getEnumValueFromInteger(this.signingAlgorithm);
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getService() {
        return this.service;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.swapReferenceTo(this.credentialsProvider, credentialsProvider);
        this.credentialsProvider = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setShouldSignParameter(Predicate<String> shouldSignParameter) {
        this.shouldSignParameter = shouldSignParameter;
    }

    public Predicate<String> getShouldSignParameter() {
        return this.shouldSignParameter;
    }

    public void setUseDoubleUriEncode(boolean useDoubleUriEncode) {
        this.useDoubleUriEncode = useDoubleUriEncode;
    }

    public boolean getUseDoubleUriEncode() {
        return this.useDoubleUriEncode;
    }

    public void setShouldNormalizeUriPath(boolean shouldNormalizeUriPath) {
        this.shouldNormalizeUriPath = shouldNormalizeUriPath;
    }

    public boolean getShouldNormalizeUriPath() {
        return this.shouldNormalizeUriPath;
    }

    public void setSignBody(AwsBodySigningConfigType signBody) {
        this.signBody = signBody.getNativeValue();
    }

    public AwsBodySigningConfigType getSignBody() {
        return AwsBodySigningConfigType.getEnumValueFromInteger(this.signBody);
    }

    public static enum AwsBodySigningConfigType {
        AWS_BODY_SIGNING_OFF(0),
        AWS_BODY_SIGNING_ON(1),
        AWS_BODY_SIGNING_UNSIGNED_PAYLOAD(2);

        private int nativeValue;
        private static Map<Integer, AwsBodySigningConfigType> enumMapping;

        private AwsBodySigningConfigType(int nativeValue) {
            this.nativeValue = nativeValue;
        }

        public int getNativeValue() {
            return this.nativeValue;
        }

        public static AwsBodySigningConfigType getEnumValueFromInteger(int value) {
            AwsBodySigningConfigType enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal body signing config type value in signing configuration");
        }

        private static Map<Integer, AwsBodySigningConfigType> buildEnumMapping() {
            HashMap<Integer, AwsBodySigningConfigType> enumMapping = new HashMap<Integer, AwsBodySigningConfigType>();
            enumMapping.put(AWS_BODY_SIGNING_OFF.getNativeValue(), AWS_BODY_SIGNING_OFF);
            enumMapping.put(AWS_BODY_SIGNING_ON.getNativeValue(), AWS_BODY_SIGNING_ON);
            enumMapping.put(AWS_BODY_SIGNING_UNSIGNED_PAYLOAD.getNativeValue(), AWS_BODY_SIGNING_UNSIGNED_PAYLOAD);
            return enumMapping;
        }

        static {
            enumMapping = AwsBodySigningConfigType.buildEnumMapping();
        }
    }

    public static enum AwsSigningAlgorithm {
        SIGV4_HEADER(0),
        SIGV4_QUERY_PARAM(1);

        private int nativeValue;
        private static Map<Integer, AwsSigningAlgorithm> enumMapping;

        private AwsSigningAlgorithm(int nativeValue) {
            this.nativeValue = nativeValue;
        }

        public int getNativeValue() {
            return this.nativeValue;
        }

        public static AwsSigningAlgorithm getEnumValueFromInteger(int value) {
            AwsSigningAlgorithm enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal signing algorithm value in signing configuration");
        }

        private static Map<Integer, AwsSigningAlgorithm> buildEnumMapping() {
            HashMap<Integer, AwsSigningAlgorithm> enumMapping = new HashMap<Integer, AwsSigningAlgorithm>();
            enumMapping.put(SIGV4_HEADER.getNativeValue(), SIGV4_HEADER);
            enumMapping.put(SIGV4_QUERY_PARAM.getNativeValue(), SIGV4_QUERY_PARAM);
            return enumMapping;
        }

        static {
            enumMapping = AwsSigningAlgorithm.buildEnumMapping();
        }
    }
}

