/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;

public class HttpRequest {
    private final String method;
    private String encodedPath;
    private List<HttpHeader> headers;
    private HttpRequestBodyStream bodyStream;

    public HttpRequest(String method, String encodedPath) {
        this(method, encodedPath, new HttpHeader[0], null);
    }

    public HttpRequest(String method, String encodedPath, HttpHeader[] headers, HttpRequestBodyStream bodyStream) {
        if (headers == null) {
            throw new IllegalArgumentException("Headers can be empty, but can't be null");
        }
        this.method = method;
        this.encodedPath = encodedPath;
        this.headers = Arrays.asList(headers);
        this.bodyStream = bodyStream;
    }

    public String getMethod() {
        return this.method;
    }

    public String getEncodedPath() {
        return this.encodedPath;
    }

    public void setEncodedPath(String encodedPath) {
        this.encodedPath = encodedPath;
    }

    public List<HttpHeader> getHeaders() {
        return this.headers;
    }

    public HttpHeader[] getHeadersAsArray() {
        return this.headers.toArray(new HttpHeader[0]);
    }

    public void addHeader(HttpHeader header) {
        this.headers.add(header);
    }

    public void addHeader(String headerName, String headerValue) {
        this.headers.add(new HttpHeader(headerName, headerValue));
    }

    public void addHeaders(HttpHeader[] headers) {
        Collections.addAll(this.headers, headers);
    }

    public HttpRequestBodyStream getBodyStream() {
        return this.bodyStream;
    }
}

