/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.iot;

import java.io.UnsupportedEncodingException;
import software.amazon.awssdk.crt.io.ClientTlsContext;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.crt.io.TlsContextOptions;
import software.amazon.awssdk.crt.mqtt.MqttConnectionConfig;
import software.amazon.awssdk.crt.utils.PackageInfo;

public final class AwsIotMqttConnectionConfigBuilder {
    private MqttConnectionConfig params = new MqttConnectionConfig();
    private TlsContextOptions tlsOptions;

    private AwsIotMqttConnectionConfigBuilder() {
    }

    public static AwsIotMqttConnectionConfigBuilder newMtlsBuilderFromPath(String certPath, String privateKeyPath) {
        AwsIotMqttConnectionConfigBuilder builder = new AwsIotMqttConnectionConfigBuilder();
        builder.params.port = 8883;
        builder.tlsOptions = TlsContextOptions.createWithMtlsFromPath(certPath, privateKeyPath);
        if (TlsContextOptions.isAlpnSupported()) {
            builder.tlsOptions.withAlpnList("x-amzn-mqtt-ca");
            builder.params.port = 443;
        }
        return builder;
    }

    public static AwsIotMqttConnectionConfigBuilder newMtlsBuilder(String certificate, String privateKey) {
        AwsIotMqttConnectionConfigBuilder builder = new AwsIotMqttConnectionConfigBuilder();
        builder.params.port = 8883;
        builder.tlsOptions = TlsContextOptions.createWithMtls(certificate, privateKey);
        if (TlsContextOptions.isAlpnSupported()) {
            builder.tlsOptions.withAlpnList("x-amzn-mqtt-ca");
            builder.params.port = 443;
        }
        return builder;
    }

    public static AwsIotMqttConnectionConfigBuilder newMtlsBuilder(byte[] certificate, byte[] privateKey) throws UnsupportedEncodingException {
        return AwsIotMqttConnectionConfigBuilder.newMtlsBuilder(new String(certificate, "UTF8"), new String(privateKey, "UTF8"));
    }

    public static AwsIotMqttConnectionConfigBuilder newMtlsPkcs12Builder(String pkcs12Path, String pkcs12Password) {
        AwsIotMqttConnectionConfigBuilder builder = new AwsIotMqttConnectionConfigBuilder();
        builder.tlsOptions = TlsContextOptions.createWithMtlsPkcs12(pkcs12Path, pkcs12Password);
        return builder;
    }

    AwsIotMqttConnectionConfigBuilder withCertificateAuthorityFromPath(String caDirPath, String caFilePath) {
        this.tlsOptions.overrideDefaultTrustStoreFromPath(caDirPath, caFilePath);
        return this;
    }

    AwsIotMqttConnectionConfigBuilder withCertificateAuthority(String caRoot) {
        this.tlsOptions.overrideDefaultTrustStore(caRoot);
        return this;
    }

    AwsIotMqttConnectionConfigBuilder withEndpoint(String endpoint) {
        this.params.endpoint = endpoint;
        return this;
    }

    AwsIotMqttConnectionConfigBuilder withPort(short port) {
        this.params.port = port;
        return this;
    }

    AwsIotMqttConnectionConfigBuilder withClientId(String clientId) {
        this.params.clientId = clientId;
        return this;
    }

    AwsIotMqttConnectionConfigBuilder withCleanSession(boolean cleanSession) {
        this.params.cleanSession = cleanSession;
        return this;
    }

    AwsIotMqttConnectionConfigBuilder withWebsocket() {
        this.params.useWebsocket = true;
        this.tlsOptions.alpnList.clear();
        this.params.port = 443;
        return this;
    }

    AwsIotMqttConnectionConfigBuilder withKeepAliveSeconds(int keepAliveSecs) {
        this.params.keepAliveSecs = keepAliveSecs;
        return this;
    }

    AwsIotMqttConnectionConfigBuilder withTimeoutMs(int timeoutMs) {
        this.params.socketOptions.connectTimeoutMs = timeoutMs;
        return this;
    }

    AwsIotMqttConnectionConfigBuilder withSocketOptions(SocketOptions socketOptions) {
        this.params.socketOptions = socketOptions;
        return this;
    }

    AwsIotMqttConnectionConfigBuilder withUsername(String username) {
        this.params.username = String.format("%s?SDK=JavaV2&Version=%s", username, new PackageInfo().toString());
        return this;
    }

    AwsIotMqttConnectionConfigBuilder withPassword(String password) {
        this.params.password = password;
        return this;
    }

    MqttConnectionConfig build() {
        if (this.tlsOptions != null) {
            this.params.tlsContext = new ClientTlsContext(this.tlsOptions);
        }
        return this.params;
    }
}

